/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zjkjcost.reserve.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateEntity;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateHistoryEntity;
import com.ejianc.business.zjkjcost.reserve.bean.PersonalApproveEntity;
import com.ejianc.business.zjkjcost.reserve.enums.ChangeStateEnum;
import com.ejianc.business.zjkjcost.reserve.mapper.AllocateMapper;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateHistoryService;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateService;
import com.ejianc.business.zjkjcost.reserve.service.IPersonalApproveService;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateDetailVO;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateHistoryVO;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateVO;
import com.ejianc.business.zjkjcost.reserve.vo.PersonalApproveVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.micrometer.core.instrument.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="allocateService")
public class AllocateServiceImpl
extends BaseServiceImpl<AllocateMapper, AllocateEntity>
implements IAllocateService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IPersonalApproveService personalApproveService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IAllocateHistoryService allocateHistoryService;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "FXYLJFP_CODE";

    @Override
    public AllocateVO saveOrUpdate(AllocateVO saveOrUpdateVO) {
        AllocateEntity entity = (AllocateEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AllocateEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setBaseShouldReserveMny(entity.getShouldReserveMny());
        entity.setBaseActualReserveMny(entity.getActualReserveMny());
        entity.setBaseReserveRatio(entity.getReserveRatio());
        entity.setChangeState(ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
        super.saveOrUpdate((Object)entity, false);
        AllocateVO vo = (AllocateVO)BeanMapper.map((Object)((Object)entity), AllocateVO.class);
        return vo;
    }

    @Override
    public Map<String, Object> getProjectUser(Long projectId, Long orgId, Long id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Boolean flag = false;
        List entities = new ArrayList();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(AllocateEntity::getProjectId, (Object)projectId);
        if (null != id) {
            lambda.ne(BaseEntity::getId, (Object)id);
        }
        if (CollectionUtils.isNotEmpty(entities = super.list((Wrapper)lambda))) {
            flag = true;
        }
        map.put("flag", flag);
        CommonResponse employeeList = this.userApi.getEmployeeList(orgId);
        ArrayList<AllocateDetailVO> detailVOS = new ArrayList<AllocateDetailVO>();
        if (employeeList.isSuccess()) {
            List data = (List)employeeList.getData();
            if (null != data && CollectionUtils.isNotEmpty((Collection)data)) {
                for (Map datum : data) {
                    if (datum.isEmpty()) continue;
                    AllocateDetailVO detailVO = new AllocateDetailVO();
                    if (null == datum.get("userId")) continue;
                    detailVO.setPersonnelId(Long.valueOf(String.valueOf(datum.get("userId"))));
                    detailVO.setPersonnelName(String.valueOf(datum.get("userName")));
                    detailVOS.add(detailVO);
                }
            }
        } else {
            throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u90e8\u4eba\u5458\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + employeeList.getMsg());
        }
        if (CollectionUtils.isNotEmpty(detailVOS)) {
            List collect = detailVOS.stream().map(t -> t.getPersonnelId()).collect(Collectors.toList());
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.in(PersonalApproveEntity::getApplicantId, collect);
            lambdachange.eq(BaseEntity::getDr, (Object)BaseVO.DR_UNDELETE);
            lambdachange.in(PersonalApproveEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
            List list = this.personalApproveService.list((Wrapper)lambdachange);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List approveVOS = BeanMapper.mapList((Iterable)list, PersonalApproveVO.class);
                for (AllocateDetailVO detailVO : detailVOS) {
                    for (PersonalApproveVO approve : approveVOS) {
                        if (!detailVO.getPersonnelId().equals(approve.getApplicantId())) continue;
                        if (StringUtils.isNotBlank((String)detailVO.getFhzdltIds())) {
                            detailVO.setFhzdltIds(detailVO.getFhzdltIds() + "," + approve.getId());
                        } else {
                            detailVO.setFhzdltIds(String.valueOf(approve.getId()));
                        }
                        List personalApproveVOS = detailVO.getPersonalApproveVOS();
                        personalApproveVOS.add(approve);
                    }
                }
            }
        }
        map.put("detailVOS", detailVOS);
        return map;
    }

    @Override
    public AllocateVO queryDetail(Long id) {
        AllocateEntity entity = (AllocateEntity)((Object)super.selectById((Serializable)id));
        AllocateVO vo = (AllocateVO)BeanMapper.map((Object)((Object)entity), AllocateVO.class);
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(AllocateHistoryEntity::getTargetId, (Object)vo.getId());
        lambdachange.eq(BaseEntity::getDr, (Object)BaseVO.DR_UNDELETE);
        lambdachange.orderByDesc(BaseEntity::getCreateTime);
        List list = this.allocateHistoryService.list((Wrapper)lambdachange);
        vo.setHistoryList(BeanMapper.mapList((Iterable)list, AllocateHistoryVO.class));
        List detailVOS = vo.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailVOS)) {
            List collect = detailVOS.stream().filter(t -> StringUtils.isNotBlank((String)t.getFhzdltIds())).map(t -> t.getFhzdltIds()).collect(Collectors.toList());
            ArrayList longs = new ArrayList();
            if (CollectionUtils.isNotEmpty(collect)) {
                for (String s : collect) {
                    String[] split = s.split(",");
                    List collect1 = Arrays.stream(split).map(t -> Long.parseLong(t.trim())).collect(Collectors.toList());
                    longs.addAll(collect1);
                }
            }
            if (CollectionUtils.isNotEmpty(longs)) {
                LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                lambda.in(BaseEntity::getId, longs);
                lambda.eq(BaseEntity::getDr, (Object)BaseVO.DR_UNDELETE);
                lambda.in(PersonalApproveEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
                List list2 = this.personalApproveService.list((Wrapper)lambda);
                if (CollectionUtils.isNotEmpty((Collection)list2)) {
                    List approveVOS = BeanMapper.mapList((Iterable)list2, PersonalApproveVO.class);
                    for (AllocateDetailVO detailVO : detailVOS) {
                        for (PersonalApproveVO approve : approveVOS) {
                            if (!detailVO.getPersonnelId().equals(approve.getApplicantId())) continue;
                            List personalApproveVOS = detailVO.getPersonalApproveVOS();
                            personalApproveVOS.add(approve);
                        }
                    }
                }
            }
        }
        return vo;
    }

    @Override
    public Map<String, Object> queryDetailFHZD(Long personnelId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String fhzdltIds = null;
        ArrayList<PersonalApproveVO> personalApproveVOS = new ArrayList<PersonalApproveVO>();
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(PersonalApproveEntity::getApplicantId, (Object)personnelId);
        lambdachange.eq(BaseEntity::getDr, (Object)BaseVO.DR_UNDELETE);
        lambdachange.in(PersonalApproveEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List list = this.personalApproveService.list((Wrapper)lambdachange);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List approveVOS = BeanMapper.mapList((Iterable)list, PersonalApproveVO.class);
            for (PersonalApproveVO approve : approveVOS) {
                fhzdltIds = null == fhzdltIds ? fhzdltIds + "," + approve.getId() : String.valueOf(approve.getId());
                personalApproveVOS.add(approve);
            }
        }
        map.put("personnelId", personnelId);
        map.put("fhzdltIds", fhzdltIds);
        map.put("personalApproveVOS", personalApproveVOS);
        return map;
    }
}

