package com.ejianc.business.zjkjcost.reserve.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.contract.vo.ContractDetailVO;
import com.ejianc.business.zjkjcost.reserve.bean.*;
import com.ejianc.business.zjkjcost.reserve.enums.ChangeStateEnum;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateChangeService;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateHistoryService;
import com.ejianc.business.zjkjcost.reserve.service.IPersonalApproveService;
import com.ejianc.business.zjkjcost.reserve.vo.*;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.micrometer.core.instrument.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.aspectj.weaver.ast.Var;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zjkjcost.reserve.mapper.AllocateMapper;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 风险预留金-项目部人员风险金预留分配表
 * 
 * @author generator
 * 
 */
@Service("allocateService")
public class AllocateServiceImpl extends BaseServiceImpl<AllocateMapper, AllocateEntity> implements IAllocateService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IPersonalApproveService personalApproveService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IAllocateHistoryService allocateHistoryService;
    @Autowired
    private IAllocateChangeService allocateChangeService;
    @Autowired
    private AllocateMapper allocateMapper;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "FXYLJFP_CODE";//此处需要根据实际修改
    @Override
    public AllocateVO saveOrUpdate(AllocateVO saveOrUpdateVO) {

        if (org.apache.commons.lang3.StringUtils.isEmpty(saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
                saveOrUpdateVO.setParentOrgName(orgVO.getName());
            }
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty(saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setOrgCode(orgVO.getCode());
                saveOrUpdateVO.setOrgName(orgVO.getName());

            }
        }
        AllocateEntity entity = BeanMapper.map(saveOrUpdateVO, AllocateEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //设置初始金额
        entity.setBaseShouldReserveMny(entity.getShouldReserveMny());
        entity.setBaseActualReserveMny(entity.getActualReserveMny());
        entity.setBaseReserveRatio(entity.getReserveRatio());
        entity.setChangeState(ChangeStateEnum.未变更.getCode());
        super.saveOrUpdate(entity, false);
        AllocateVO allocateVO = queryDetail(entity.getId());
//        AllocateVO vo = BeanMapper.map(entity, AllocateVO.class);
        return allocateVO;
    }

    @Override
    public Map<String,Object> getProjectUser(Long projectId, Long orgId, Long id) {
        Map<String,Object> map = new HashMap<>();
        Boolean flag = false; //代表项目下没数据
        List<AllocateEntity> entities = new ArrayList<>();
        LambdaQueryWrapper<AllocateEntity> lambda = Wrappers.<AllocateEntity>lambdaQuery();
        lambda.eq(AllocateEntity::getProjectId, projectId);
        if(null!=id){
            lambda.ne(AllocateEntity::getId,id);
        }
        entities = super.list(lambda);
        if(CollectionUtils.isNotEmpty(entities)){
            flag = true;  //代表项目下有数据
        }
        map.put("flag",flag);
        CommonResponse<List<Map<String, Object>>> employeeList = userApi.getEmployeeList(orgId);
        ArrayList<AllocateDetailVO> detailVOS = new ArrayList<>();
        if(employeeList.isSuccess()){
            List<Map<String, Object>> data = employeeList.getData();
                if(null!=data && CollectionUtils.isNotEmpty(data)){
                    for (Map<String, Object> datum : data) {
                        if(!datum.isEmpty()){
                            AllocateDetailVO detailVO = new AllocateDetailVO();
                            if(null!=datum.get("userId")){
                                detailVO.setPersonnelId(Long.valueOf(String.valueOf(datum.get("userId"))));
                                detailVO.setPersonnelName(String.valueOf(datum.get("userName")));
                                detailVOS.add(detailVO);
                            }
                        }
                    }
                }
        }else {
            throw new BusinessException("查询项目部人员失败，原因："+employeeList.getMsg());
        }
        if(CollectionUtils.isNotEmpty(detailVOS)){
            List<Long> collect = detailVOS.stream().map(t -> t.getPersonnelId()).collect(Collectors.toList());
            LambdaQueryWrapper<PersonalApproveEntity> lambdachange = Wrappers.<PersonalApproveEntity>lambdaQuery();
            lambdachange.in(PersonalApproveEntity::getApplicantId, collect);
            lambdachange.eq(PersonalApproveEntity::getDr, BaseVO.DR_UNDELETE);
            lambdachange.in(PersonalApproveEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
            List<PersonalApproveEntity> list = personalApproveService.list(lambdachange);
            if(CollectionUtils.isNotEmpty(list)){
                List<PersonalApproveVO> approveVOS = BeanMapper.mapList(list, PersonalApproveVO.class);
                for (AllocateDetailVO detailVO : detailVOS) {
                    for (PersonalApproveVO approve : approveVOS) {
                        if(detailVO.getPersonnelId().equals(approve.getApplicantId())){
                            if(StringUtils.isNotBlank(detailVO.getFhzdltIds())){
                                detailVO.setFhzdltIds(detailVO.getFhzdltIds()+","+approve.getId());
                            }else {
                                detailVO.setFhzdltIds(String.valueOf(approve.getId()));
                            }
                            List<PersonalApproveVO> personalApproveVOS = detailVO.getPersonalApproveVOS();
                            personalApproveVOS.add(approve);
                        }
                    }
                }
            }
        }
        map.put("detailVOS",detailVOS);
        return map;
    }

    @Override
    public AllocateVO queryDetail(Long id) {
        AllocateEntity entity = super.selectById(id);
        AllocateVO vo = BeanMapper.map(entity, AllocateVO.class);
//        LambdaQueryWrapper<AllocateHistoryEntity> lambdachange = Wrappers.<AllocateHistoryEntity>lambdaQuery();
//        lambdachange.eq(AllocateHistoryEntity::getTargetId,vo.getId());
//        lambdachange.eq(AllocateHistoryEntity::getDr, BaseVO.DR_UNDELETE);
//        lambdachange.orderByDesc(AllocateHistoryEntity::getCreateTime);
//        List<AllocateHistoryEntity> list = allocateHistoryService.list(lambdachange);
        List<AllocateChangeVO> bgHistory = allocateMapper.getBGHistory(vo.getId());
        vo.setChangeList(bgHistory);
        List<AllocateDetailVO> detailVOS = vo.getDetailList();
        if(CollectionUtils.isNotEmpty(detailVOS)){
            List<String> collect = detailVOS.stream().filter(t->StringUtils.isNotBlank(t.getFhzdltIds())).map(t -> t.getFhzdltIds()).collect(Collectors.toList());
            List<Long> longs = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(collect))
            for (String s : collect) {
                String[] split = s.split(",");
                List<Long> collect1 = Arrays.stream(split).map(t -> Long.parseLong(t.trim())).collect(Collectors.toList());
                longs.addAll(collect1);
            }
            if(CollectionUtils.isNotEmpty(longs)){
                LambdaQueryWrapper<PersonalApproveEntity> lambda = Wrappers.<PersonalApproveEntity>lambdaQuery();
                lambda.in(PersonalApproveEntity::getId, longs);
                lambda.eq(PersonalApproveEntity::getDr, BaseVO.DR_UNDELETE);
                lambda.in(PersonalApproveEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
                List<PersonalApproveEntity> list2 = personalApproveService.list(lambda);
                if(CollectionUtils.isNotEmpty(list2)){
                    List<PersonalApproveVO> approveVOS = BeanMapper.mapList(list2, PersonalApproveVO.class);
                    for (AllocateDetailVO detailVO : detailVOS) {
                        for (PersonalApproveVO approve : approveVOS) {
                            if(detailVO.getPersonnelId().equals(approve.getApplicantId())){
                                List<PersonalApproveVO> personalApproveVOS = detailVO.getPersonalApproveVOS();
                                personalApproveVOS.add(approve);
                            }
                        }
                    }
                }
            }
        }
        return vo;
    }

    @Override
    public Map<String, Object> queryDetailFHZD(Long personnelId) {
        Map<String, Object> map = new HashMap<>();
        String fhzdltIds = null;
        List<PersonalApproveVO> personalApproveVOS = new ArrayList<>();
        LambdaQueryWrapper<PersonalApproveEntity> lambdachange = Wrappers.<PersonalApproveEntity>lambdaQuery();
        lambdachange.eq(PersonalApproveEntity::getApplicantId, personnelId);
        lambdachange.eq(PersonalApproveEntity::getDr, BaseVO.DR_UNDELETE);
        lambdachange.in(PersonalApproveEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        List<PersonalApproveEntity> list = personalApproveService.list(lambdachange);
        if(CollectionUtils.isNotEmpty(list)){
            List<PersonalApproveVO> approveVOS = BeanMapper.mapList(list, PersonalApproveVO.class);
            for (PersonalApproveVO approve : approveVOS) {
                    if(null==fhzdltIds){
                        fhzdltIds=fhzdltIds+","+approve.getId();
                    }else {
                        fhzdltIds=String.valueOf(approve.getId());
                    }
                    personalApproveVOS.add(approve);
            }
        }
        map.put("personnelId",personnelId);
        map.put("fhzdltIds",fhzdltIds);
        map.put("personalApproveVOS",personalApproveVOS);
        return map;
    }

    @Override
    public Object excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        Long orgId = Long.valueOf(request.getParameter("orgId"));
        String personnelIds = request.getParameter("personnelIds");
        String[] split = personnelIds.split(",");
        List<String> personnelIdList = Arrays.asList(split);
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<AllocateDetailVO> successList = new ArrayList<>();
        List<AllocateDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        else {
            CommonResponse<List<Map<String, Object>>> employeeList = userApi.getEmployeeList(orgId);
            Map<String,Long> userIdMap = new HashMap<String,Long>();
            Map<String,String> checkUserIdMap = new HashMap<String,String>();
            if(CollectionUtils.isNotEmpty(personnelIdList)){
                checkUserIdMap = personnelIdList.stream().collect(Collectors.toMap(t -> t, Function.identity(), (v1, v2) -> v2));
            }
            if(employeeList.isSuccess()){
                List<Map<String, Object>> data = employeeList.getData();
                if(null!=data && CollectionUtils.isNotEmpty(data)){
                    for (Map<String, Object> datum : data) {
                        if(!datum.isEmpty()){
                            AllocateDetailVO detailVO = new AllocateDetailVO();
                            if(null!=datum.get("userId") && null!=datum.get("userName")){
//                                detailVO.setPersonnelId(Long.valueOf(String.valueOf(datum.get("userId"))));
//                                detailVO.setPersonnelName(String.valueOf(datum.get("userName")));
//                                detailVOS.add(detailVO);
                                userIdMap.put(String.valueOf(datum.get("userName")),Long.valueOf(String.valueOf(datum.get("userId"))));
                            }
                        }
                    }
                }
            }else {
                throw new BusinessException("查询项目部人员失败，原因："+employeeList.getMsg());
            }
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    AllocateDetailVO detailVO = new AllocateDetailVO();
                    detailVO.setId(IdWorker.getId());

                    detailVO.setPersonnelName(datas.get(0));//姓名
                    Long personnelId = userIdMap.get(datas.get(0));
                    if(null==personnelId){
                        detailVO.setErrorMsg("该人员不在当前项目下！");
                        errorList.add(detailVO);
                        continue ;
                    }
                    detailVO.setPersonnelId(personnelId);
                    String s = checkUserIdMap.get(String.valueOf(personnelId));
                    if(null!=s){
                        detailVO.setErrorMsg("该人员已存在！");
                        errorList.add(detailVO);
                        continue ;
                    }
                    detailVO.setPostName(datas.get(1));//岗位职务
                    try {
                        String detailRatio = datas.get(2);//比例
                        detailVO.setDetailRatio(org.apache.commons.lang3.StringUtils.isNotBlank(detailRatio)? new BigDecimal(detailRatio) : null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("风险金比例格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String shouldDetailMny = datas.get(3);//应分配额
                        detailVO.setShouldDetailMny(org.apache.commons.lang3.StringUtils.isNotBlank(shouldDetailMny) ? new BigDecimal(shouldDetailMny) : null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("应预留风险金格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String actualDetailMny = datas.get(4);//实际分配额
                        detailVO.setActualDetailMny(org.apache.commons.lang3.StringUtils.isNotBlank(actualDetailMny) ? new BigDecimal(actualDetailMny) : null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("实际预留风险金格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    detailVO.setFileIds("");
                    detailVO.setRowState("add");
                    detailVO.setBillCode(String.valueOf(new Date().getTime()));
                    detailVO.setMemo(datas.get(5));//备注
                    successList.add(detailVO);
                }
            }
            if(CollectionUtils.isNotEmpty(successList)){
                List<Long> collect = successList.stream().map(t -> t.getPersonnelId()).collect(Collectors.toList());
                LambdaQueryWrapper<PersonalApproveEntity> lambdachange = Wrappers.<PersonalApproveEntity>lambdaQuery();
                lambdachange.in(PersonalApproveEntity::getApplicantId, collect);
                lambdachange.eq(PersonalApproveEntity::getDr, BaseVO.DR_UNDELETE);
                lambdachange.in(PersonalApproveEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
                List<PersonalApproveEntity> list = personalApproveService.list(lambdachange);
                if(CollectionUtils.isNotEmpty(list)){
                    List<PersonalApproveVO> approveVOS = BeanMapper.mapList(list, PersonalApproveVO.class);
                    for (AllocateDetailVO detailVO : successList) {
                        for (PersonalApproveVO approve : approveVOS) {
                            if(detailVO.getPersonnelId().equals(approve.getApplicantId())){
                                if(io.micrometer.core.instrument.util.StringUtils.isNotBlank(detailVO.getFhzdltIds())){
                                    detailVO.setFhzdltIds(detailVO.getFhzdltIds()+","+approve.getId());
                                }else {
                                    detailVO.setFhzdltIds(String.valueOf(approve.getId()));
                                }
                                List<PersonalApproveVO> personalApproveVOS = detailVO.getPersonalApproveVOS();
                                personalApproveVOS.add(approve);
                            }
                        }
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return json;
    }


}
