package com.ejianc.business.zjkjcost.reserve.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateEntity;
import com.ejianc.business.zjkjcost.reserve.bean.PersonalApproveEntity;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateService;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zjkjcost.reserve.mapper.DepartmentApproveMapper;
import com.ejianc.business.zjkjcost.reserve.bean.DepartmentApproveEntity;
import com.ejianc.business.zjkjcost.reserve.service.IDepartmentApproveService;

import java.util.*;

/**
 * 风险预留金-项目部预留金返还审批表
 * 
 * @author generator
 * 
 */
@Service("departmentApproveService")
public class DepartmentApproveServiceImpl extends BaseServiceImpl<DepartmentApproveMapper, DepartmentApproveEntity> implements IDepartmentApproveService{
    @Autowired
    private IAllocateService allocateService;
    @Override
    public Map<String, Object> queryByProject(Long projectId, Long id) {
        Map<String, Object> map = new HashMap<>();
        Boolean flag = false; //代表项目下没数据
        List<DepartmentApproveEntity> entities = new ArrayList<>();
        LambdaQueryWrapper<DepartmentApproveEntity> lambda = Wrappers.<DepartmentApproveEntity>lambdaQuery();
        lambda.eq(DepartmentApproveEntity::getProjectId, projectId);
        if(null!=id){
            lambda.ne(DepartmentApproveEntity::getId,id);
        }
        lambda.notIn(DepartmentApproveEntity::getBillState, Arrays.asList(1, 3));
        entities = super.list(lambda);
        if(CollectionUtils.isNotEmpty(entities)){
            flag = true;  //代表项目下有数据
        }
        map.put("flag",flag);
        AllocateVO allocateVO = new AllocateVO();
        LambdaQueryWrapper<AllocateEntity> lambda2 = Wrappers.<AllocateEntity>lambdaQuery();
        lambda2.eq(AllocateEntity::getProjectId, projectId);
        lambda2.eq(AllocateEntity::getDr, BaseVO.DR_UNDELETE);
        lambda2.in(AllocateEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        lambda2.orderByDesc(AllocateEntity::getCreateTime);
        List<AllocateEntity> list = allocateService.list(lambda2);
        if(CollectionUtils.isNotEmpty(list)){
            allocateVO= BeanMapper.map(list.get(0),AllocateVO.class);
        }
        map.put("allocateVO",allocateVO);
        return map;
    }
}
