/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zjkjcost.finish.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zjkjcost.finish.bean.ApplyEntity;
import com.ejianc.business.zjkjcost.finish.service.IApplyService;
import com.ejianc.business.zjkjcost.finish.vo.ApplyDetailVO;
import com.ejianc.business.zjkjcost.finish.vo.ApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"apply"})
@Api(value="\u7ae3\u5de5\u8003\u6838-\u76ee\u6807\u8d23\u4efb\u4e66\u7ae3\u5de5\u8003\u6838\u5151\u73b0\u7533\u62a5-\u4e3b\u8868", tags={"\u7ae3\u5de5\u8003\u6838-\u76ee\u6807\u8d23\u4efb\u4e66\u7ae3\u5de5\u8003\u6838\u5151\u73b0\u7533\u62a5-\u4e3b\u8868"})
public class ApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZJKJ_FINISH_APPLY";
    @Autowired
    private IApplyService service;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ApplyVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody ApplyVO saveOrUpdateVO) {
        ApplyEntity entity;
        OrgVO orgVO;
        CommonResponse orgResponse;
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setOrgCode(orgVO.getCode());
            saveOrUpdateVO.setOrgName(orgVO.getName());
        }
        if ((entity = (ApplyEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ApplyEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ApplyVO vo = (ApplyVO)BeanMapper.map((Object)((Object)entity), ApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ApplyVO> queryDetail(@RequestParam Long id) {
        ApplyEntity entity = (ApplyEntity)((Object)this.service.selectById(id));
        ApplyVO vo = (ApplyVO)BeanMapper.map((Object)((Object)entity), ApplyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/getApplyByContractId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ApplyVO> getApplyByContractId(@RequestParam Long contractId) {
        ApplyVO applyVO = this.service.getApplyByContractId(contractId);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)applyVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u9879\u76ee\u4e0b\u662f\u5426\u6709\u6570\u636e")
    @RequestMapping(value={"/queryByContractId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> queryByContractId(@RequestParam Long contractId, Long id) {
        Boolean flag = false;
        List entities = new ArrayList();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ApplyEntity::getContractId, (Object)contractId);
        if (null != id) {
            lambda.ne(BaseEntity::getId, (Object)id);
        }
        if (CollectionUtils.isNotEmpty(entities = this.service.list((Wrapper)lambda))) {
            flag = true;
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)flag);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApplyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ApplyVO applyVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List listVo = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            listVo = BeanMapper.mapList((Iterable)list, ApplyVO.class);
            for (ApplyVO applyVO : listVo) {
                applyVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)applyVO.getBillState()).getDescription());
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", listVo);
        ExcelExport.getInstance().export("apply-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refApplyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ApplyVO>> refApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/uploadExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ApplyDetailVO> successList = new ArrayList<ApplyDetailVO>();
        ArrayList errorList = new ArrayList();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        BigDecimal distributionMny = BigDecimal.ZERO;
        BigDecimal actualMny = BigDecimal.ZERO;
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ApplyDetailVO detailVO = new ApplyDetailVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                detailVO.setTargetManage((String)datas.get(0));
                detailVO.setUnit((String)datas.get(1));
                detailVO.setTargetDuty((String)datas.get(2));
                detailVO.setTargetFinish((String)datas.get(3));
                detailVO.setOpinion((String)datas.get(4));
                detailVO.setSign((String)datas.get(5));
                detailVO.setMemo((String)datas.get(6));
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("distributionMny", (Object)distributionMny);
        json.put("actualMny", (Object)actualMny);
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/downloadExcel"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"apply-detail-import.xlsx", (String)"\u8003\u6838\u5151\u73b0\u8be6\u60c5\u6a21\u677f");
    }
}

