package com.ejianc.business.zjkjcost.reserve.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zjkjcost.reserve.bean.*;
import com.ejianc.business.zjkjcost.reserve.enums.BillTypeEnum;
import com.ejianc.business.zjkjcost.reserve.enums.ChangeStateEnum;
import com.ejianc.business.zjkjcost.reserve.enums.ChangeTypeEnum;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateHistoryService;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateService;
import com.ejianc.business.zjkjcost.reserve.service.IPersonalApproveService;
import com.ejianc.business.zjkjcost.reserve.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.micrometer.core.instrument.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zjkjcost.reserve.mapper.AllocateChangeMapper;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateChangeService;

import java.math.BigDecimal;
import java.sql.Time;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 风险预留金-项目部人员风险金预留分配变更表
 * 
 * @author generator
 * 
 */
@Service("allocateChangeService")
public class AllocateChangeServiceImpl extends BaseServiceImpl<AllocateChangeMapper, AllocateChangeEntity> implements IAllocateChangeService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPersonalApproveService personalApproveService;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IAllocateService allocateService;

    @Autowired
    private IAllocateHistoryService allocateHistoryService;

    private static final String BILL_CODE = "FXYLJFPBG_CODE";//此处需要根据实际修改
    private static final String CONTRACT_FILE_SOURCE_TYPE_Z = "zjkj-allocate";//主表
    private static final String CONTRACT_FILE_SOURCE_TYPE_BG = "zjkj-allocateChange";//变更
    private static final String CONTRACT_FILE_SOURCE_TYPE_JL = "zjkj-allocateHistory";//记录



    @Override
    public AllocateChangeVO saveOrUpdate(AllocateChangeVO saveOrUpdateVO) {
        AllocateChangeEntity entity = BeanMapper.map(saveOrUpdateVO, AllocateChangeEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillCode(entity.getBillCode()+ entity.getChangeVersion());
        }

        //变更只能存在一条未生效的
        //查询语句，主id一致，且变更id不同，单据状态不为已通过或已提交的
        LambdaQueryWrapper<AllocateChangeEntity> lambdachange = Wrappers.<AllocateChangeEntity>lambdaQuery();
        lambdachange.eq(AllocateChangeEntity::getTargetId,entity.getTargetId());
        if(entity.getId() != null) {
            lambdachange.ne(AllocateChangeEntity::getId,entity.getId());
        }
        lambdachange.notIn(AllocateChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("存在未生效的变更单!");
        }

        super.saveOrUpdate(entity, false);
        //回显原单据信息
        saveWriteAllocate(entity);
//        AllocateChangeVO vo = BeanMapper.map(entity, AllocateChangeVO.class);
        AllocateChangeVO changeVO = queryDetail(entity.getId());
        return changeVO;
    }


    @Override
    public void delete(Long changId) {
        delWriteAllocate(changId);
        super.removeById(changId);
    }

    /**
     * 保存回写单据信息
     * @param changeEntity
     */
    private void saveWriteAllocate(AllocateChangeEntity changeEntity){
        LambdaUpdateWrapper<AllocateEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(AllocateEntity::getChangeId, changeEntity.getId());
        updateWrapper.set(AllocateEntity::getChangeCode, changeEntity.getBillCode());
        updateWrapper.set(AllocateEntity::getChangeVersion, changeEntity.getChangeVersion());
        updateWrapper.set(AllocateEntity::getChangeState, ChangeStateEnum.变更中.getCode());
        updateWrapper.set(AllocateEntity::getChangeTime, changeEntity.getChangeTime());
        updateWrapper.eq(AllocateEntity::getId, changeEntity.getTargetId());
        allocateService.update(allocateService.selectById(changeEntity.getTargetId()), updateWrapper, false);
    }

    /**
     * 删除回写单据信息
     * @param
     */
    private void delWriteAllocate(Long changeId){
        AllocateChangeEntity changeEntity = super.selectById(changeId);
        LambdaQueryWrapper<AllocateChangeEntity> lambdachange = Wrappers.<AllocateChangeEntity>lambdaQuery();
        lambdachange.eq(AllocateChangeEntity::getTargetId,changeEntity.getTargetId());
        lambdachange.eq(AllocateChangeEntity::getDr, BaseVO.DR_UNDELETE);
        lambdachange.ne(AllocateChangeEntity::getId,changeEntity.getId());
        int count = super.count(lambdachange);
        AllocateEntity allocateEntity = allocateService.selectById(changeEntity.getTargetId());
        allocateEntity.setChangeCode(null);
        allocateEntity.setChangeId(null);
        allocateEntity.setChangeState(count > 0 ? ChangeStateEnum.已变更.getCode() : ChangeStateEnum.未变更.getCode());
        allocateEntity.setChangeTime(null);
        allocateEntity.setChangeVersion(allocateEntity.getChangeVersion()==1?null:allocateEntity.getChangeVersion()-1);
        allocateService.update(allocateEntity, new QueryWrapper<AllocateEntity>().eq("id",allocateEntity.getId()), false);
    }

    /**
     * @Author yangst
     * @Description  新增根据原单据主键查询变更需要的字段
     * @param targetId
     */
    @Override
    public AllocateChangeVO addConvertByConId(Long targetId) {
        AllocateVO allocateVO = allocateService.queryDetail(targetId);
        AllocateChangeVO allocateChangeVO = BeanMapper.map(allocateVO, AllocateChangeVO.class);
        //设置变更前金额
        allocateChangeVO.setBeforeShouldReserveMny(allocateChangeVO.getShouldReserveMny());
        allocateChangeVO.setBeforeActualReserveMny(allocateChangeVO.getActualReserveMny());
        allocateChangeVO.setBeforeReserveRatio(allocateChangeVO.getReserveRatio());
        allocateChangeVO.setBillState(null);
        allocateChangeVO.setTargetId(targetId);
        allocateChangeVO.setChangeVersion(allocateVO.getChangeVersion() == null ? 1 : allocateVO.getChangeVersion()+ 1);
        allocateChangeVO.setCreateUserCode(null);
        allocateChangeVO.setCreateTime(null);
        allocateChangeVO.setUpdateUserCode(null);
        allocateChangeVO.setUpdateTime(null);
        allocateChangeVO.setChangeTime(new Date());
        allocateChangeVO.setId(null);
        //设置明细表字段
        List<AllocateChangeDetailVO> allocateChangeDetailList = allocateChangeVO.getDetailList();
        if(CollectionUtils.isNotEmpty(allocateChangeDetailList)){
            for (AllocateChangeDetailVO allocateChangeDetailVO : allocateChangeDetailList) {
                allocateChangeDetailVO.setTargetDetailId(allocateChangeDetailVO.getId());
                allocateChangeDetailVO.setBeforeDetailRatio(allocateChangeDetailVO.getDetailRatio());
                allocateChangeDetailVO.setBeforeActualDetailMny(allocateChangeDetailVO.getActualDetailMny());
                allocateChangeDetailVO.setBeforeShouldDetailMny(allocateChangeDetailVO.getShouldDetailMny());
                allocateChangeDetailVO.setChangeType(ChangeTypeEnum.未变更.getCode());
                allocateChangeDetailVO.setRowState("add");
                allocateChangeDetailVO.setCreateUserCode(null);
                allocateChangeDetailVO.setCreateTime(null);
                allocateChangeDetailVO.setUpdateUserCode(null);
                allocateChangeDetailVO.setUpdateTime(null);
//                allocateChangeDetailVO.setId(null);
            }
        }
        return allocateChangeVO;
    }

    /**
     * 变更单据生效创建记录文件并回写主合同
     * @param changeId
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeId, String billTypeCode) {
        String resp = null;
        /**更新变更*/
        AllocateChangeEntity changeEntity = super.selectById(changeId);
        changeEntity.setEffectiveTime(new Date());
        super.saveOrUpdate(changeEntity,false);
        logger.info("进入变更终审！变更表数据------------->: {}", JSONObject.toJSONString(changeEntity));

        /**复制合同表数据到记录表 begin */
        AllocateEntity allocateEntity = allocateService.selectById(changeEntity.getTargetId());
        AllocateHistoryEntity historyEntity = BeanMapper.map(allocateEntity, AllocateHistoryEntity.class);
        historyEntity.setId(null);
        historyEntity.setTargetId(allocateEntity.getId());
        Map<Long, Integer> contIdVersionMap =  new HashMap<>();

        logger.info("变更前主数据: {}", JSONObject.toJSONString(allocateEntity));
        logger.info("变更前主子表detail数据: {}", JSONObject.toJSONString(allocateEntity.getDetailList()));
        logger.info("记录表从主表复制的数据: {}", JSONObject.toJSONString(historyEntity));
        logger.info("记录表从主表复制的数据的子表detail数据: {}", JSONObject.toJSONString(historyEntity.getDetailList()));

        if(CollectionUtils.isNotEmpty(historyEntity.getDetailList())){
            historyEntity.getDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setTargetDetailId(vo.getId());
                vo.setId(null);
            });
        }
        logger.info("记录表从主合同表复制的子表detail数据，设置id后的值: {}", JSONObject.toJSONString(historyEntity.getDetailList()));
        allocateHistoryService.saveOrUpdate(historyEntity, false);
        logger.info("审批-变更记录表保存主合同数据成功！");
        //原同步到记录单据中
        copyFile(allocateEntity.getId().toString(), BillTypeEnum.主表.getCode(),CONTRACT_FILE_SOURCE_TYPE_Z,
                historyEntity.getId().toString(), BillTypeEnum.记录表.getCode(), CONTRACT_FILE_SOURCE_TYPE_JL, false);
        /**复制主单据数据到记录表 end */

        /**更新变更表主表数据到原单据 begin */
        logger.info("更新变更数据到主数据表,主数据---------------->: {}", JSONObject.toJSONString(allocateEntity));
        logger.info("更新变更数据到主数据表,变更数据---------------->: {}", JSONObject.toJSONString(changeEntity));
        //基本信息
        allocateEntity.setEmployeeId(changeEntity.getEmployeeId());
        allocateEntity.setEmployeeName(changeEntity.getEmployeeName());
        allocateEntity.setEmployeeTime(changeEntity.getEmployeeTime());
        allocateEntity.setBaseReserveRatio(changeEntity.getBaseReserveRatio());
        allocateEntity.setBaseActualReserveMny(changeEntity.getBaseActualReserveMny());
        allocateEntity.setBaseShouldReserveMny(changeEntity.getBaseShouldReserveMny());
        allocateEntity.setReserveRatio(changeEntity.getReserveRatio());
        allocateEntity.setActualReserveMny(changeEntity.getActualReserveMny());
        allocateEntity.setShouldReserveMny(changeEntity.getShouldReserveMny());
        allocateEntity.setChangeState(ChangeStateEnum.已变更.getCode());
        //同步变更单附件（不包含变更变更附件）到原合同
        copyFile(changeId.toString(), BillTypeEnum.变更表.getCode(),CONTRACT_FILE_SOURCE_TYPE_BG,
                allocateEntity.getId().toString(), BillTypeEnum.主表.getCode(), CONTRACT_FILE_SOURCE_TYPE_Z, true);
        List<AllocateDetailEntity>  saveDetailList= new ArrayList<>();//新增更新子表
        List<AllocateDetailEntity> detailList = allocateEntity.getDetailList();
        List<AllocateChangeDetailEntity>  detailChangeList= changeEntity.getDetailList();
        //变更单变更子表
        Map<Long, AllocateChangeDetailEntity> mapBGChang = detailChangeList.stream().filter(t->t.getTargetDetailId()!=null).collect(Collectors.toMap(AllocateChangeDetailEntity::getTargetDetailId, Function.identity()));
        //变更单新增子表
        Map<Long, AllocateChangeDetailEntity> mapADDChang = detailChangeList.stream().filter(t -> t.getTargetDetailId() == null).collect(Collectors.toMap(AllocateChangeDetailEntity::getTargetDetailId, Function.identity()));
        if(CollectionUtils.isNotEmpty(detailList)){
            for (AllocateDetailEntity detailEntity : detailList) {
                AllocateChangeDetailEntity entity = mapBGChang.get(detailEntity.getId());
                if(null==entity){
                    detailEntity.setRowState("del");
                    saveDetailList.add(detailEntity);
                }else {
                    AllocateDetailEntity map = BeanMapper.map(entity, AllocateDetailEntity.class);
                    map.setId(map.getTargetDetailId());
                    map.setVersion(detailEntity.getVersion());
                    map.setChangeType(null);
                    map.setAllocateId(allocateEntity.getId());
                    saveDetailList.add(map);
                }
            }
        }
        if(CollectionUtils.isNotEmpty(mapADDChang.values())){
            List<AllocateChangeDetailEntity> values = new ArrayList<>(mapADDChang.values());
            for (AllocateChangeDetailEntity value : values) {
                AllocateDetailEntity map = BeanMapper.map(value, AllocateDetailEntity.class);
                map.setId(null);
                map.setChangeType(null);
                map.setRowState("add");
                map.setAllocateId(allocateEntity.getId());
                saveDetailList.add(map);
            }
        }
        allocateEntity.setDetailList(saveDetailList);
        allocateService.saveOrUpdate(allocateEntity,false);
        logger.info("更新变更表合同状态和数据,---------->： {}", JSONObject.toJSONString(changeEntity));
        /**更新变更表主表数据到单据 end */
        logger.info("更新主表数据成功,---------->: {}", JSONObject.toJSONString(allocateEntity));
        /**更新变更子表数据到原合同子表 end */
        return CommonResponse.success("变更单生效，回写合同成功！");
    }

    @Override
    public AllocateChangeVO queryDetail(Long id) {
        AllocateChangeEntity changeEntity = super.selectById(id);
        AllocateChangeVO changeVO = BeanMapper.map(changeEntity, AllocateChangeVO.class);
        List<AllocateChangeDetailVO> detailVOS = changeVO.getDetailList();
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(detailVOS)){
            List<String> collect = detailVOS.stream().filter(t->StringUtils.isNotBlank(t.getFhzdltIds())).map(t -> t.getFhzdltIds()).collect(Collectors.toList());
            List<Long> longs = new ArrayList<>();
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(collect))
                for (String s : collect) {
                    String[] split = s.split(",");
                    List<Long> collect1 = Arrays.stream(split).map(t -> Long.parseLong(t.trim())).collect(Collectors.toList());
                    longs.addAll(collect1);
                }
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(longs)){
                LambdaQueryWrapper<PersonalApproveEntity> lambda = Wrappers.<PersonalApproveEntity>lambdaQuery();
                lambda.in(PersonalApproveEntity::getId, longs);
                lambda.eq(PersonalApproveEntity::getDr, BaseVO.DR_UNDELETE);
                lambda.in(PersonalApproveEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
                List<PersonalApproveEntity> list2 = personalApproveService.list(lambda);
                if(org.apache.commons.collections.CollectionUtils.isNotEmpty(list2)){
                    List<PersonalApproveVO> approveVOS = BeanMapper.mapList(list2, PersonalApproveVO.class);
                    for (AllocateChangeDetailVO detailVO : detailVOS) {
                        for (PersonalApproveVO approve : approveVOS) {
                            if(detailVO.getPersonnelId().equals(approve.getApplicantId())){
                                List<PersonalApproveVO> personalApproveVOS = detailVO.getPersonalApproveVOS();
                                personalApproveVOS.add(approve);
                            }
                        }
                    }
                }
            }
        }
        return changeVO;

    }

    /**
     * 文件复制
     *
     * @param sourceBillId 源单据Id(@RequestParam(name="sourceBillId") String sourceBillId,
     *                                                                                                                      @RequestParam(name="sourceBillType") String sourceBillType,
     *                                                           @RequestParam(name="sourceBillSourceType") String sourceBillSourceType,
     *                                                           @RequestParam(name="targetBillId") String targetBillId,
     *                                                           @RequestParam(name="targetBillType") String targetBillType,
     *                                                           @RequestParam(name="targetBillSourceType") String targetBillSourceType
     * @param sourceBillType 源单据类型
     * @param sourceBillSourceType 源单据附件业务类型
     * @param targetBillId 目标单据Id
     * @param targetBillType 目标单据类型
     * @return
     */
    private void copyFile(String sourceBillId,String sourceBillType,String sourceBillSourceType,String targetBillId,String targetBillType,String targetBillSourceType, boolean flag) {
        //同步合同附件列表
        CommonResponse<String> stringCommonResponse = attachmentApi.copyFilesFromSourceBillToTargetBill(sourceBillId, sourceBillType, sourceBillSourceType, targetBillId, targetBillType, targetBillSourceType);
        if(!stringCommonResponse.isSuccess()){
            logger.info("同步附件管理中的附件失败--------------->失败信息------------>：{}",stringCommonResponse.getMsg());
        }
        logger.info("同步合同文件--------------->同步类型-{},sourceBillId-{},sourceBillType-{},sourceBillSourceType-{},targetBillId-{},targetBillType-{},targetBillSourceType--{},:--{}"
                ,(flag ? "变更->主" : "主->记录"),sourceBillId, sourceBillType, sourceBillSourceType, targetBillId, targetBillType, targetBillSourceType, stringCommonResponse.getMsg());
    }
}
