package com.ejianc.business.zjkjcost.manage.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.zjkjcost.manage.bean.BookEntity;
import com.ejianc.business.zjkjcost.manage.service.IBookService;
import com.ejianc.business.zjkjcost.manage.vo.BookVO;

/**
 * 项目目标管理责任书
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("book")
@Api(value = "项目目标管理责任书", tags = {"项目目标管理责任书"})
public class BookController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "COST_BOOK";//此处需要根据实际修改

    @Autowired
    private IBookService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BookVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody BookVO saveOrUpdateVO) {
    	BookEntity entity = BeanMapper.map(saveOrUpdateVO, BookEntity.class);
        List<BookEntity> entities = new ArrayList<>();
        LambdaQueryWrapper<BookEntity> lambda = Wrappers.<BookEntity>lambdaQuery();
        lambda.eq(BookEntity::getProjectId, saveOrUpdateVO.getProjectId());
        if(null!=saveOrUpdateVO.getId()){
            lambda.ne(BookEntity::getId,saveOrUpdateVO.getId());
        }
        entities = service.list(lambda);
        if(CollectionUtils.isNotEmpty(entities)){
            throw new BusinessException("该项目下已经存在项目目标管理责任书，不允许新增!");
        }
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	BookVO vo = BeanMapper.map(entity, BookVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BookVO> queryDetail(@RequestParam Long id) {
    	BookEntity entity = service.selectById(id);
    	BookVO vo = BeanMapper.map(entity, BookVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @ApiOperation("查询项目下是否有数据")
    @RequestMapping(value = "/queryByProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> queryByProject(@RequestParam Long projectId,Long id) {
        Boolean flag = false; //代表项目下没数据
        List<BookEntity> entities = new ArrayList<>();
        LambdaQueryWrapper<BookEntity> lambda = Wrappers.<BookEntity>lambdaQuery();
        lambda.eq(BookEntity::getProjectId, projectId);
        if(null!=id){
            lambda.ne(BookEntity::getId,id);
        }
        entities = service.list(lambda);
        if(CollectionUtils.isNotEmpty(entities)){
            flag = true;  //代表项目下有数据
        }
        return CommonResponse.success("查询数据成功！",flag);
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BookVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (BookVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(BookVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BookVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        List<OrgVO> orgVOList = null;
        orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<BookEntity> page = service.queryPage(param,false);
        IPage<BookVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BookVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BookEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Book-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refBookData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BookVO>> refBookData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<BookEntity> page = service.queryPage(param,false);
        IPage<BookVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BookVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
