package com.ejianc.business.zjkjcost.reserve.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateChangeEntity;
import com.ejianc.business.zjkjcost.reserve.bean.PersonalApproveEntity;
import com.ejianc.business.zjkjcost.reserve.service.IPersonalApproveService;
import com.ejianc.business.zjkjcost.reserve.vo.*;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.micrometer.core.instrument.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zjkjcost.reserve.mapper.AllocateHistoryMapper;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateHistoryEntity;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateHistoryService;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 风险预留金-项目部人员风险金预留分配变更记录表 
 * 
 * @author generator
 * 
 */
@Service("allocateHistoryService")
public class AllocateHistoryServiceImpl extends BaseServiceImpl<AllocateHistoryMapper, AllocateHistoryEntity> implements IAllocateHistoryService{

    @Autowired
    private IPersonalApproveService personalApproveService;

    @Override
    public AllocateHistoryVO queryDetail(Long id) {
        AllocateHistoryEntity historyEntity = super.selectById(id);
        AllocateHistoryVO historyVO = BeanMapper.map(historyEntity, AllocateHistoryVO.class);
        List<AllocateHistoryDetailVO> detailVOS = historyVO.getDetailList();
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(detailVOS)){
            List<String> collect = detailVOS.stream().filter(t-> StringUtils.isNotBlank(t.getFhzdltIds())).map(t -> t.getFhzdltIds()).collect(Collectors.toList());
            List<Long> longs = new ArrayList<>();
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(collect))
                for (String s : collect) {
                    String[] split = s.split(",");
                    List<Long> collect1 = Arrays.stream(split).map(t -> Long.parseLong(t.trim())).collect(Collectors.toList());
                    longs.addAll(collect1);
                }
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(longs)){
                LambdaQueryWrapper<PersonalApproveEntity> lambda = Wrappers.<PersonalApproveEntity>lambdaQuery();
                lambda.in(PersonalApproveEntity::getId, longs);
                lambda.eq(PersonalApproveEntity::getDr, BaseVO.DR_UNDELETE);
                lambda.in(PersonalApproveEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
                List<PersonalApproveEntity> list2 = personalApproveService.list(lambda);
                if(org.apache.commons.collections.CollectionUtils.isNotEmpty(list2)){
                    List<PersonalApproveVO> approveVOS = BeanMapper.mapList(list2, PersonalApproveVO.class);
                    for (AllocateHistoryDetailVO detailVO : detailVOS) {
                        for (PersonalApproveVO approve : approveVOS) {
                            if(detailVO.getPersonnelId().equals(approve.getApplicantId())){
                                List<PersonalApproveVO> personalApproveVOS = detailVO.getPersonalApproveVOS();
                                personalApproveVOS.add(approve);
                            }
                        }
                    }
                }
            }
        }
        return historyVO;
    }
}
