package com.ejianc.business.zjkjcost.reserve.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.plan.vo.MasterPlanExportVO;
import com.ejianc.business.zjkjcost.finish.bean.ApplyEntity;
import com.ejianc.business.zjkjcost.node.bean.NodeGrantDetailEntity;
import com.ejianc.business.zjkjcost.node.vo.NodeGrantDetailVO;
import com.ejianc.business.zjkjcost.node.vo.NodeGrantVO;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateDetailEntity;
import com.ejianc.business.zjkjcost.reserve.bean.PersonalApproveEntity;
import com.ejianc.business.zjkjcost.reserve.enums.ChangeStateEnum;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateChangeDetailService;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateDetailService;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateHistoryDetailService;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateDetailVO;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateExportVO;
import com.ejianc.business.zjkjcost.reserve.vo.PersonalApproveVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.aspectj.weaver.ast.Var;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.zjkjcost.reserve.bean.AllocateEntity;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateService;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 风险预留金-项目部人员风险金预留分配表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("allocate")
@Api(value = "风险预留金-项目部人员风险金预留分配表", tags = {"风险预留金-项目部人员风险金预留分配表"})
public class AllocateController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IUserApi userApi;

    private static final String BILL_CODE = "FXYLJFP_CODE";//此处需要根据实际修改

    @Autowired
    private IAllocateService service;
    @Autowired
    private IAllocateDetailService allocateDetailService;
    @Autowired
    private IAllocateChangeDetailService allocateChangeDetailService;
    @Autowired
    private IAllocateHistoryDetailService allocateHistoryDetailService;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AllocateVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody AllocateVO saveOrUpdateVO) {
        AllocateVO vo= service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AllocateVO> queryDetail(@RequestParam Long id) {
    	AllocateVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @ApiOperation("查询项目校验/子表")
    @RequestMapping(value = "/getProjectUser", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> getProjectUser(@RequestParam Long projectId, Long orgId, Long id) {
        Map<String, Object> map = service.getProjectUser(projectId, orgId, id);
        return CommonResponse.success("查询详情数据成功！",map);
    }

    @ApiOperation("查询单个人员返还/转抵")
    @RequestMapping(value = "/queryDetailFHZD", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> queryDetailFHZD(@RequestParam Long personnelId) {
        Map<String, Object> map = service.queryDetailFHZD(personnelId);
        return CommonResponse.success("查询详情数据成功！",map);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AllocateVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (AllocateVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(AllocateVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    @ApiOperation("查询项目下是否有数据")
    @RequestMapping(value = "/isThereData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> isThereData(@RequestParam Long projectId,Long id) {
        Boolean flag = false; //代表项目下没数据
        List<AllocateEntity> entities = new ArrayList<>();
        LambdaQueryWrapper<AllocateEntity> lambda = Wrappers.<AllocateEntity>lambdaQuery();
        lambda.eq(AllocateEntity::getProjectId, projectId);
        if(null!=id){
            lambda.ne(AllocateEntity::getId,id);
        }
        entities = service.list(lambda);
        if(CollectionUtils.isNotEmpty(entities)){
            flag = true;  //代表项目下有数据
        }
        return CommonResponse.success("查询数据成功！",flag);
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AllocateVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<AllocateEntity> page = service.queryPage(param,false);
        IPage<AllocateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AllocateVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * 导出子表数据库数据
     *
     * @param id 请求
     * @param type    请求
     * @param response    请求
     */
    @RequestMapping(value = "/excelExportFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMaterialFromDatabase(@RequestBody Map<String,Object> map, HttpServletResponse response) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("allocateId", new Parameter(QueryParam.EQ, Long.valueOf(String.valueOf(map.get("id")))));
        List<AllocateDetailVO> allocateDetailVOS = new ArrayList<>();
        switch (Integer.valueOf(String.valueOf(map.get("type")))){
            case 1:
                allocateDetailVOS= BeanMapper.mapList(allocateDetailService.queryList(queryParam),AllocateDetailVO.class);
                break;
            case 2:
                allocateDetailVOS= BeanMapper.mapList(allocateChangeDetailService.queryList(queryParam),AllocateDetailVO.class);
                break;
            case 3:
                allocateDetailVOS= BeanMapper.mapList(allocateHistoryDetailService.queryList(queryParam),AllocateDetailVO.class);
                break;
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", allocateDetailVOS);
        ExcelExport.getInstance().export("AllocateDetail-export.xlsx", beans, response);
    }

    /**
     * 导出子表列表数据
     *
     * @param list     列表
     * @param response 请求
     */
    @RequestMapping(value = "/excelExportFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMaterialFromPage(@RequestBody List<AllocateDetailVO> list,
                                            HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("AllocateDetail-export.xlsx", beans, response);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<AllocateEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<AllocateExportVO> voList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            for(AllocateEntity val:list){
                AllocateExportVO vo = BeanMapper.map(val, AllocateExportVO.class);
                if(val.getCreateTime()!=null){
                    vo.setCreateTime(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss",val.getCreateTime()));
                }
                if(val.getShouldReserveMny()!=null){
                    vo.setShouldReserveMny(val.getShouldReserveMny().setScale(2, BigDecimal.ROUND_HALF_UP)+"");
                }
                if(val.getActualReserveMny()!=null){
                    vo.setActualReserveMny(val.getActualReserveMny().setScale(2, BigDecimal.ROUND_HALF_UP)+"");
                }
                vo.setChangeState(ChangeStateEnum.getEnumByCode(val.getChangeState()).getDescription());
                vo.setBillState(BillStateEnum.getEnumByStateCode(val.getBillState()).getDescription());
                voList.add(vo);
            }
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("Allocate-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refAllocateData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AllocateVO>> refAllocateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AllocateEntity> page = service.queryPage(param,false);
        IPage<AllocateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AllocateVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadExcel")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "AllocateDetail-import.xlsx", "人员列表模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/uploadExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        Object o = service.excelImportMaterial(request, response);
        return CommonResponse.success(o);
    }
}
