package com.ejianc.business.zjkjcost.finish.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.settlementmanage.api.ISettlementApi;
import com.ejianc.business.settlementmanage.vo.SettlementCountersignVO;
import com.ejianc.business.zjkjcost.finish.vo.ApplyTemplateVO;
import com.ejianc.business.zjkjcost.manage.bean.BookEntity;
import com.ejianc.business.zjkjcost.manage.service.IBookService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zjkjcost.finish.mapper.ApplyTemplateMapper;
import com.ejianc.business.zjkjcost.finish.bean.ApplyTemplateEntity;
import com.ejianc.business.zjkjcost.finish.service.IApplyTemplateService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 竣工考核-目标责任书竣工考核兑现申报-模板子表
 * 
 * @author generator
 * 
 */
@Service("applyTemplateService")
public class ApplyTemplateServiceImpl extends BaseServiceImpl<ApplyTemplateMapper, ApplyTemplateEntity> implements IApplyTemplateService{
    @Autowired
    private ISettlementApi settlementApi;
    @Autowired
    private IBookService bookService;
    @Override
    public List<ApplyTemplateVO> queryTempList(Long contractId,Long projectId) {
        List<ApplyTemplateEntity> list = super.list();
        List<ApplyTemplateVO> applyListVO = BeanMapper.mapList(list, ApplyTemplateVO.class);
        CommonResponse<SettlementCountersignVO> settlementResponse = settlementApi.querySettleById(contractId);
        if (!settlementResponse.isSuccess()){
            throw new BusinessException("获取总包结算会审记录失败!错误信息:"+settlementResponse.getMsg());
        }
//        private java.util.Date actualCompletionDate; // 实际竣工日期
        SettlementCountersignVO settlement = settlementResponse.getData();
        String targetFinish = "";
        if (settlement!=null){
            Date actualCommencementDate = settlement.getActualCommencementDate();//实际开关日期
            Date actualCompletionDate = settlement.getActualCompletionDate();        // 实际竣工日期
            DateFormatUtils.format(actualCommencementDate,"yy-MM-dd" );
            targetFinish = DateFormatUtils.format(actualCommencementDate,"yy-MM-dd" )+"-"+DateFormatUtils.format(actualCompletionDate,"yy-MM-dd" );
        }
        //根据项目id获取项目目标管理责任书
        List<Integer> status = new ArrayList<>();
        status.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        status.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        LambdaQueryWrapper<BookEntity> lambda = Wrappers.<BookEntity>lambdaQuery();
        lambda.eq(BookEntity::getProjectId, projectId);
        lambda.in(BookEntity::getBillState, status);
        lambda.orderByDesc(BookEntity::getCreateTime);
        List<BookEntity> bookEntityList = bookService.list(lambda);
        if (CollectionUtils.isNotEmpty(bookEntityList)){
            BookEntity bookEntity = bookEntityList.get(0);
            for (ApplyTemplateVO applyTemplateVO : applyListVO){
                if (applyTemplateVO.getTargetManage().equals("工程工期")){
                    applyTemplateVO.setTargetDuty(bookEntity.getDuration()+"");
                    applyTemplateVO.setTargetFinish(targetFinish);
                }
                if (applyTemplateVO.getTargetManage().equals("工程质量")){
                    applyTemplateVO.setTargetDuty(bookEntity.getConstructionQuality());
                }
                if (applyTemplateVO.getTargetManage().equals("安全生产")){
                    applyTemplateVO.setTargetDuty(bookEntity.getSafetyProduction());
                }
                if (applyTemplateVO.getTargetManage().equals("CI形象")){
                    applyTemplateVO.setTargetDuty(bookEntity.getIcImage()+"");
                }
                if (applyTemplateVO.getTargetManage().equals("上缴款")){
                    applyTemplateVO.setTargetDuty(roundHalfUp(2,bookEntity.getUpPayment())+"");
                }
                if (applyTemplateVO.getTargetManage().equals("风险金预留")){
                    applyTemplateVO.setTargetDuty(roundHalfUp(2,bookEntity.getRiskFund())+"");
                }

            }

        }

        return applyListVO;
    }

    private BigDecimal roundHalfUp(int newScale,BigDecimal bigDecimal){
        if(newScale<0 || newScale>8){
            newScale=8;
        }
        if(null==bigDecimal){
            return new BigDecimal("0").setScale(newScale, BigDecimal.ROUND_HALF_UP);
        }
        return bigDecimal.setScale(newScale, BigDecimal.ROUND_HALF_UP);
    }
}

