/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zjkjcost.finish.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.settlementmanage.api.ISettlementApi;
import com.ejianc.business.settlementmanage.vo.SettlementCountersignVO;
import com.ejianc.business.zjkjcost.finish.bean.ApplyTemplateEntity;
import com.ejianc.business.zjkjcost.finish.mapper.ApplyTemplateMapper;
import com.ejianc.business.zjkjcost.finish.service.IApplyTemplateService;
import com.ejianc.business.zjkjcost.finish.vo.ApplyTemplateVO;
import com.ejianc.business.zjkjcost.manage.bean.BookEntity;
import com.ejianc.business.zjkjcost.manage.service.IBookService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="applyTemplateService")
public class ApplyTemplateServiceImpl
extends BaseServiceImpl<ApplyTemplateMapper, ApplyTemplateEntity>
implements IApplyTemplateService {
    @Autowired
    private ISettlementApi settlementApi;
    @Autowired
    private IBookService bookService;

    @Override
    public List<ApplyTemplateVO> queryTempList(Long contractId, Long projectId) {
        List list = super.list();
        List applyListVO = BeanMapper.mapList((Iterable)list, ApplyTemplateVO.class);
        CommonResponse settlementResponse = this.settlementApi.querySettleById(contractId);
        if (!settlementResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u603b\u5305\u7ed3\u7b97\u4f1a\u5ba1\u8bb0\u5f55\u5931\u8d25!\u9519\u8bef\u4fe1\u606f:" + settlementResponse.getMsg());
        }
        SettlementCountersignVO settlement = (SettlementCountersignVO)settlementResponse.getData();
        String targetFinish = "";
        if (settlement != null) {
            Date actualCommencementDate = settlement.getActualCommencementDate();
            Date actualCompletionDate = settlement.getActualCompletionDate();
            DateFormatUtils.format((Date)actualCommencementDate, (String)"yy-MM-dd");
            targetFinish = DateFormatUtils.format((Date)actualCommencementDate, (String)"yy-MM-dd") + "-" + DateFormatUtils.format((Date)actualCompletionDate, (String)"yy-MM-dd");
        }
        ArrayList<Integer> status = new ArrayList<Integer>();
        status.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        status.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BookEntity::getProjectId, (Object)projectId);
        lambda.in(BookEntity::getBillState, status);
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List bookEntityList = this.bookService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)bookEntityList)) {
            BookEntity bookEntity = (BookEntity)((Object)bookEntityList.get(0));
            for (ApplyTemplateVO applyTemplateVO : applyListVO) {
                if (applyTemplateVO.getTargetManage().equals("\u5de5\u7a0b\u5de5\u671f")) {
                    applyTemplateVO.setTargetDuty(bookEntity.getDuration() + "");
                    applyTemplateVO.setTargetFinish(targetFinish);
                }
                if (applyTemplateVO.getTargetManage().equals("\u5de5\u7a0b\u8d28\u91cf")) {
                    applyTemplateVO.setTargetDuty(bookEntity.getConstructionQuality());
                }
                if (applyTemplateVO.getTargetManage().equals("\u5b89\u5168\u751f\u4ea7")) {
                    applyTemplateVO.setTargetDuty(bookEntity.getSafetyProduction());
                }
                if (applyTemplateVO.getTargetManage().equals("CI\u5f62\u8c61")) {
                    applyTemplateVO.setTargetDuty(this.roundHalfUp(2, bookEntity.getIcImage()) + "");
                }
                if (applyTemplateVO.getTargetManage().equals("\u4e0a\u7f34\u6b3e")) {
                    applyTemplateVO.setTargetDuty(this.roundHalfUp(2, bookEntity.getUpPayment()) + "");
                }
                if (!applyTemplateVO.getTargetManage().equals("\u98ce\u9669\u91d1\u9884\u7559")) continue;
                applyTemplateVO.setTargetDuty(this.roundHalfUp(2, bookEntity.getRiskFund()) + "");
            }
        }
        return applyListVO;
    }

    private BigDecimal roundHalfUp(int newScale, BigDecimal bigDecimal) {
        if (newScale < 0 || newScale > 8) {
            newScale = 8;
        }
        if (null == bigDecimal) {
            return new BigDecimal("0").setScale(newScale, 4);
        }
        return bigDecimal.setScale(newScale, 4);
    }
}

