package com.ejianc.business.zjkjcost.reserve.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zjkjcost.reserve.bean.*;
import com.ejianc.business.zjkjcost.reserve.service.IPersonalApproveService;
import com.ejianc.business.zjkjcost.reserve.vo.*;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.micrometer.core.instrument.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zjkjcost.reserve.mapper.AllocateHistoryMapper;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateHistoryService;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 风险预留金-项目部人员风险金预留分配变更记录表 
 * 
 * @author generator
 * 
 */
@Service("allocateHistoryService")
public class AllocateHistoryServiceImpl extends BaseServiceImpl<AllocateHistoryMapper, AllocateHistoryEntity> implements IAllocateHistoryService{

    @Autowired
    private IPersonalApproveService personalApproveService;

    @Override
    public AllocateHistoryVO queryDetail(Long id) {
        AllocateHistoryEntity historyEntity = super.selectById(id);
        AllocateHistoryVO historyVO = BeanMapper.map(historyEntity, AllocateHistoryVO.class);
        List<AllocateHistoryDetailVO> detailVOS = historyVO.getDetailList();
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(detailVOS)){
            //处理孙子表信息
            List<AllocateHistoryApproveEntity> allocateApproveList = historyEntity.getApproveList();
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(allocateApproveList)){
                List<AllocateHistoryApproveVO> allocateApproveVOList = BeanMapper.mapList(allocateApproveList,AllocateHistoryApproveVO.class);
                Map<Long, List<AllocateHistoryApproveVO>> bidderMap = allocateApproveVOList.stream().
                        collect(Collectors.groupingBy(AllocateHistoryApproveVO::getAllocateDetailId));
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailVOS)){
                    for (AllocateHistoryDetailVO detailVO : detailVOS){
                        List<AllocateHistoryApproveVO> approveVOS = bidderMap.get(detailVO.getId());
                        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(approveVOS)){
                            detailVO.setAllocateApproveVOS(approveVOS);
                        }
                    }
                    historyVO.setDetailList(detailVOS);
                }
            }
        }
        return historyVO;
    }
}
