package com.ejianc.business.zjkjcost.optimization.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目优化立项申报占用类型
 */
public enum OccupyTypeEnum {

    /**
     * 项目优化立项申报占用类型：0、项目优化效益计算；
     */
    项目优化效益计算(0, "项目优化效益计算"),

    /**
     * 项目优化立项申报占用类型：1、项目优化奖励申请；
     */
    项目优化奖励申请(1, "项目优化奖励申请");


    private Integer code;
    private String description;
    private static Map<Integer, OccupyTypeEnum> enumMap = new HashMap<>();

    OccupyTypeEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(OccupyTypeEnum.class).stream().collect(Collectors
                .toMap(OccupyTypeEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static OccupyTypeEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }
}
