/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zjkjcost.reserve.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zjkjcost.manage.bean.BookEntity;
import com.ejianc.business.zjkjcost.manage.service.IBookService;
import com.ejianc.business.zjkjcost.reserve.bean.DepartmentApproveEntity;
import com.ejianc.business.zjkjcost.reserve.service.IDepartmentApproveService;
import com.ejianc.business.zjkjcost.reserve.vo.DepartmentApproveVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"departmentApprove"})
@Api(value="\u98ce\u9669\u9884\u7559\u91d1-\u9879\u76ee\u90e8\u9884\u7559\u91d1\u8fd4\u8fd8\u5ba1\u6279\u8868", tags={"\u98ce\u9669\u9884\u7559\u91d1-\u9879\u76ee\u90e8\u9884\u7559\u91d1\u8fd4\u8fd8\u5ba1\u6279\u8868"})
public class DepartmentApproveController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "COST_YLJ";
    @Autowired
    private IDepartmentApproveService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBookService bookService;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DepartmentApproveVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody DepartmentApproveVO saveOrUpdateVO) {
        OrgVO orgVO;
        CommonResponse orgResponse;
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
            saveOrUpdateVO.setParentOrgName(orgVO.getName());
        }
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setOrgCode(orgVO.getCode());
            saveOrUpdateVO.setOrgName(orgVO.getName());
        }
        DepartmentApproveEntity entity = (DepartmentApproveEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DepartmentApproveEntity.class));
        List entities = new ArrayList();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(DepartmentApproveEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
        if (null != saveOrUpdateVO.getId()) {
            lambda.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        }
        lambda.notIn(DepartmentApproveEntity::getBillState, Arrays.asList(1, 3));
        entities = this.service.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty(entities)) {
            throw new BusinessException("\u8be5\u9879\u76ee\u4e0b\u6709\u672a\u751f\u6548\u7684\u8fd4\u8fd8\u5ba1\u6279\u8868\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        DepartmentApproveVO vo = (DepartmentApproveVO)BeanMapper.map((Object)((Object)entity), DepartmentApproveVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DepartmentApproveVO> queryDetail(@RequestParam Long id) {
        DepartmentApproveEntity entity = (DepartmentApproveEntity)((Object)this.service.selectById(id));
        DepartmentApproveVO vo = (DepartmentApproveVO)BeanMapper.map((Object)((Object)entity), DepartmentApproveVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u9879\u76ee\u4e0b\u662f\u5426\u6709\u6570\u636e")
    @RequestMapping(value={"/queryByProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, Object>> queryByProject(@RequestParam Long projectId, Long id) {
        Map<String, Object> map = this.service.queryByProject(projectId, id);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", map);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DepartmentApproveVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DepartmentApproveVO departmentApproveVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DepartmentApproveVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List orgVOList = null;
        orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DepartmentApproveVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List departmentApproveVOS = BeanMapper.mapList((Iterable)list, DepartmentApproveVO.class);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", departmentApproveVOS);
        ExcelExport.getInstance().export("DepartmentApprove-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refDepartmentApproveData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DepartmentApproveVO>> refDepartmentApproveData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DepartmentApproveVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/payMoney"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> payMoney(@RequestParam Long projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        List list = this.bookService.list((Wrapper)queryWrapper);
        BigDecimal upPayment = null;
        if (list != null && list.size() > 0) {
            BookEntity bookEntity = (BookEntity)((Object)list.get(0));
            upPayment = bookEntity.getUpPayment();
        }
        return CommonResponse.success(upPayment);
    }
}

