package com.ejianc.business.zjkjcost.reserve.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zjkjcost.manage.bean.BookEntity;
import com.ejianc.business.zjkjcost.manage.service.IBookService;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateEntity;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.zjkjcost.reserve.bean.DepartmentApproveEntity;
import com.ejianc.business.zjkjcost.reserve.service.IDepartmentApproveService;
import com.ejianc.business.zjkjcost.reserve.vo.DepartmentApproveVO;

/**
 * 风险预留金-项目部预留金返还审批表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("departmentApprove")
@Api(value = "风险预留金-项目部预留金返还审批表", tags = {"风险预留金-项目部预留金返还审批表"})
public class DepartmentApproveController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "COST_YLJ";//此处需要根据实际修改

    @Autowired
    private IDepartmentApproveService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IBookService bookService;

    @Autowired
    private IAllocateService allocateService;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DepartmentApproveVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody DepartmentApproveVO saveOrUpdateVO) {
        if (org.apache.commons.lang3.StringUtils.isEmpty(saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
                saveOrUpdateVO.setParentOrgName(orgVO.getName());
            }
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty(saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setOrgCode(orgVO.getCode());
                saveOrUpdateVO.setOrgName(orgVO.getName());

            }
        }
    	DepartmentApproveEntity entity = BeanMapper.map(saveOrUpdateVO, DepartmentApproveEntity.class);
        List<DepartmentApproveEntity> entities = new ArrayList<>();
        LambdaQueryWrapper<DepartmentApproveEntity> lambda = Wrappers.<DepartmentApproveEntity>lambdaQuery();
        lambda.eq(DepartmentApproveEntity::getProjectId, saveOrUpdateVO.getProjectId());
        if(null!=saveOrUpdateVO.getId()){
            lambda.ne(DepartmentApproveEntity::getId,saveOrUpdateVO.getId());
        }
        lambda.notIn(DepartmentApproveEntity::getBillState,Arrays.asList(1, 3));
        entities = service.list(lambda);
        if(CollectionUtils.isNotEmpty(entities)){
            throw new BusinessException("该项目下有未生效的返还审批表，不允许新增!");
        }

    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	DepartmentApproveVO vo = BeanMapper.map(entity, DepartmentApproveVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DepartmentApproveVO> queryDetail(@RequestParam Long id) {
    	DepartmentApproveEntity entity = service.selectById(id);
    	DepartmentApproveVO vo = BeanMapper.map(entity, DepartmentApproveVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @ApiOperation("查询项目下是否有数据")
    @RequestMapping(value = "/queryByProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String,Object>> queryByProject(@RequestParam Long projectId,Long id) {
        QueryWrapper<BookEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", 1, 3);
        List<BookEntity> list = bookService.list(queryWrapper);
        BigDecimal upPayment = BigDecimal.ZERO;
        if ( list.size() > 0) {
            BookEntity bookEntity = list.get(0);
            upPayment = bookEntity.getUpPayment();
        }

        Map<String, Object> map = service.queryByProject(projectId, id);
        map.put("upPayment",upPayment);
        return CommonResponse.success("查询数据成功！",map);
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DepartmentApproveVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (DepartmentApproveVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DepartmentApproveVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DepartmentApproveVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        List<OrgVO> orgVOList = null;
        orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<DepartmentApproveEntity> page = service.queryPage(param,false);
        IPage<DepartmentApproveVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DepartmentApproveVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DepartmentApproveEntity> list = service.queryList(param);
        List<DepartmentApproveVO> departmentApproveVOS = BeanMapper.mapList(list, DepartmentApproveVO.class);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();

        beans.put("records", departmentApproveVOS);
        ExcelExport.getInstance().export("DepartmentApprove-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refDepartmentApproveData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DepartmentApproveVO>> refDepartmentApproveData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DepartmentApproveEntity> page = service.queryPage(param,false);
        IPage<DepartmentApproveVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DepartmentApproveVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @ApiOperation("项目部人员风险金预留分配表")
    @RequestMapping(value = "/queryApprove", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryApprove(@RequestParam(value = "projectId") Long projectId) {
        QueryWrapper<AllocateEntity> queryWrapper2 = new QueryWrapper<>();
        queryWrapper2.eq("dr", 0);
        queryWrapper2.in("bill_state", "1", "3");
        queryWrapper2.eq("project_id", projectId);
        List<AllocateEntity > entityList = allocateService.list(queryWrapper2);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < entityList.size(); i++) {
            if (entityList.get(i).getActualReserveMny() != null) {
                total = total.add(entityList.get(i).getActualReserveMny());//实际预留风险金（元）
            }
        }
        return CommonResponse.success("查询成功", total);
    }


}
