package com.ejianc.business.zjkjcost.finish.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zjkjcost.finish.bean.OutEntity;
import com.ejianc.business.zjkjcost.finish.mapper.OutMapper;
import com.ejianc.business.zjkjcost.finish.service.IOutService;
import com.ejianc.business.zjkjcost.finish.vo.OutVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 竣工考核-竣工目标考核奖金发放-主表
 * 
 * @author generator
 * 
 */
@Service("outService")
public class OutServiceImpl extends BaseServiceImpl<OutMapper, OutEntity> implements IOutService{

    @Override
    public OutVO getOutByContractId(Long contractId) {
        List<Integer> statusList = new ArrayList<>();
        statusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        statusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        LambdaQueryWrapper<OutEntity> lambda = Wrappers.<OutEntity>lambdaQuery();
        lambda.eq(OutEntity::getContractId, contractId);
        lambda.in(OutEntity::getBillState, statusList);

        List<OutEntity> list = super.list(lambda);
        OutEntity outEntity = new OutEntity();
        if (CollectionUtils.isNotEmpty(list)){
            outEntity = list.get(0);
        }
        return BeanMapper.map(outEntity, OutVO.class);
    }
}
