package com.ejianc.business.zjkjcost.node.service.impl;

import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zjkjcost.node.mapper.NodeAssessMapper;
import com.ejianc.business.zjkjcost.node.bean.NodeAssessEntity;
import com.ejianc.business.zjkjcost.node.service.INodeAssessService;

import java.util.Arrays;

/**
 * 节点考核-项目节点奖分析考核
 * 
 * @author generator
 * 
 */
@Service("nodeAssessService")
public class NodeAssessServiceImpl extends BaseServiceImpl<NodeAssessMapper, NodeAssessEntity> implements INodeAssessService{

    /**
     * 一个合同下只能有一个自由态的单据
     *
     * @param contractId 合同id
     * @param id         本单据id
     * @return 校验结果：true 校验失败！ false：校验通过
     */
    @Override
    public boolean checkOnly(Long contractId, Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("billState", new Parameter(QueryParam.NOT_IN, Arrays.asList(1, 3)));
        if (id != null) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        return CollectionUtils.isNotEmpty(super.queryList(queryParam, false));
    }
}
