package com.ejianc.business.zjkjcost.node.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zjkjcost.node.bean.NodeGrantEntity;
import com.ejianc.business.zjkjcost.node.mapper.NodeGrantMapper;
import com.ejianc.business.zjkjcost.node.service.INodeGrantService;
import com.ejianc.business.zjkjcost.node.vo.NodeGrantVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 节点考核-节点目标奖金考核发放
 * 
 * @author generator
 * 
 */
@Service("nodeGrantService")
public class NodeGrantServiceImpl extends BaseServiceImpl<NodeGrantMapper, NodeGrantEntity> implements INodeGrantService{
    /**
     * 一个合同下只能有一个自由态的单据
     *
     * @param contractId 合同id
     * @param id         本单据id
     * @return 校验结果：true 校验失败！ false：校验通过
     */
    @Override
    public boolean checkOnly(Long contractId, Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("billState", new Parameter(QueryParam.NOT_IN, Arrays.asList(1, 3)));
        if (id != null) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        return CollectionUtils.isNotEmpty(super.queryList(queryParam, false));
    }

    @Override
    public NodeGrantVO getGrantByContractId(Long contractId) {
        List<Integer> statusList = new ArrayList<>();
        statusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        statusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        LambdaQueryWrapper<NodeGrantEntity> lambda = Wrappers.<NodeGrantEntity>lambdaQuery();
        lambda.eq(NodeGrantEntity::getContractId, contractId);
        lambda.in(NodeGrantEntity::getBillState, statusList);

        List<NodeGrantEntity> list = super.list(lambda);
        NodeGrantEntity nodeGrantEntity = new NodeGrantEntity();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(list)){
            nodeGrantEntity = list.get(0);
        }
        return BeanMapper.map(nodeGrantEntity, NodeGrantVO.class);
    }
}
