package com.ejianc.business.zjkjcost.reserve.service;

import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.zjkjcost.reserve.bean.PersonalApproveEntity;

import java.util.List;
import java.util.Map;

/**
 * 风险预留金-个人风险金过程返还、转抵审批表
 * 
 * @author generator
 * 
 */
public interface IPersonalApproveService extends IBaseService<PersonalApproveEntity> {
    /**
     * 查询返还金额和转抵金额汇总
     * @param projectId 项目id
     * @param applicantId 申请人id
     * @return
     */
    Map<String,Object> queryTotal(Long projectId, Long applicantId);

    /**
     * 根据项目id和申请人id查询表的主键id
     * @param projectId 项目id
     * @param applicantId 申请人id
     * @return
     */
    List<Map<String,Object>> selectIds(Long projectId, Long applicantId);
}
