package com.ejianc.business.zjkjcost.reserve.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateApproveEntity;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateEntity;
import com.ejianc.business.zjkjcost.reserve.bean.PersonalApproveEntity;
import com.ejianc.business.zjkjcost.reserve.enums.ChangeStateEnum;
import com.ejianc.business.zjkjcost.reserve.mapper.AllocateMapper;
import com.ejianc.business.zjkjcost.reserve.service.*;
import com.ejianc.business.zjkjcost.reserve.vo.*;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.micrometer.core.instrument.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 风险预留金-项目部人员风险金预留分配表
 * 
 * @author generator
 * 
 */
@Service("allocateService")
public class AllocateServiceImpl extends BaseServiceImpl<AllocateMapper, AllocateEntity> implements IAllocateService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IPersonalApproveService personalApproveService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IAllocateHistoryService allocateHistoryService;
    @Autowired
    private IAllocateChangeService allocateChangeService;
    @Autowired
    private IAllocateDetailService allocateDetailService;
    @Autowired
    private AllocateMapper allocateMapper;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "FXYLJFP_CODE";//此处需要根据实际修改
    @Override
    public AllocateVO saveOrUpdate(AllocateVO saveOrUpdateVO) {

        if (org.apache.commons.lang3.StringUtils.isEmpty(saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
                saveOrUpdateVO.setParentOrgName(orgVO.getName());
            }
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty(saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setOrgCode(orgVO.getCode());
                saveOrUpdateVO.setOrgName(orgVO.getName());

            }
        }
        List<AllocateDetailVO> detailList = saveOrUpdateVO.getDetailList();
        List<AllocateApproveEntity> allocateApproveList =new ArrayList<>();
        Map<Long, AllocateApproveVO> collect = saveOrUpdateVO.getApproveList().stream().collect(Collectors.toMap(AllocateApproveVO::getId, detail -> detail, (v1, v2) -> v2));
        if (CollectionUtils.isNotEmpty(detailList)){
            for (AllocateDetailVO detailVO : detailList){
                List<AllocateApproveVO> approveVOS = detailVO.getAllocateApproveVOS();
                if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(approveVOS)){
                    for (AllocateApproveVO approveVO : approveVOS){
                        if("del"!=detailVO.getRowState()){
                            if (detailVO.getId() == null){
                                long id = IdWorker.getId();
                                detailVO.setId(id);
                            }
                        }else {
                            if(null==approveVO.getId()){
                                continue;
                            }else {
                                approveVO.setRowState("del");
                            }
                        }
                        if(collect.containsKey(approveVO.getId())){
                            collect.remove(approveVO.getId());
                        }
                        approveVO.setAllocateDetailId(detailVO.getId());
                        AllocateApproveEntity allocateApproveEntity = BeanMapper.map(approveVO, AllocateApproveEntity.class);
                        allocateApproveList.add(allocateApproveEntity);
                    }
                }
            }
        }
        if (MapUtils.isNotEmpty(collect)) {
            //若有剩余项，则说这些被删除
            collect.values().forEach(c -> {
                c.setRowState("del");
                allocateApproveList.add(BeanMapper.map(c, AllocateApproveEntity.class));
            });
        }
        AllocateEntity entity = BeanMapper.map(saveOrUpdateVO, AllocateEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        LambdaQueryWrapper<AllocateEntity> lambda = Wrappers.<AllocateEntity>lambdaQuery();
        lambda.eq(AllocateEntity::getProjectId, saveOrUpdateVO.getProjectId());
        if(null!=saveOrUpdateVO.getId()){
            lambda.ne(AllocateEntity::getId,saveOrUpdateVO.getId());
        }
        List<AllocateEntity> list = super.list(lambda);
        if(CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("该项目下已存在项目部人员风险金预留分配表，不允许新增!");
        }
        //设置初始金额
        entity.setBaseShouldReserveMny(entity.getShouldReserveMny());
        entity.setBaseActualReserveMny(entity.getActualReserveMny());
        entity.setBaseReserveRatio(entity.getReserveRatio());
        entity.setChangeState(ChangeStateEnum.未变更.getCode());
        entity.setApproveList(allocateApproveList);
        super.saveOrUpdate(entity, false);
        AllocateVO allocateVO = queryDetail(entity.getId());
//        AllocateVO vo = BeanMapper.map(entity, AllocateVO.class);
        return allocateVO;
    }

    @Override
    public Map<String,Object> getProjectUser(Long projectId, Long orgId, Long id) {
        Map<String,Object> map = new HashMap<>();
        Boolean flag = false; //代表项目下没数据
        List<AllocateEntity> entities = new ArrayList<>();
        LambdaQueryWrapper<AllocateEntity> lambda = Wrappers.<AllocateEntity>lambdaQuery();
        lambda.eq(AllocateEntity::getProjectId, projectId);
        if(null!=id){
            lambda.ne(AllocateEntity::getId,id);
        }
        entities = super.list(lambda);
        if(CollectionUtils.isNotEmpty(entities)){
            flag = true;  //代表项目下有数据
        }
        map.put("flag",flag);
        CommonResponse<List<Map<String, Object>>> employeeList = userApi.getEmployeeList(orgId);
        ArrayList<AllocateDetailVO> detailVOS = new ArrayList<>();
        if(employeeList.isSuccess()){
            List<Map<String, Object>> data = employeeList.getData();
                if(null!=data && CollectionUtils.isNotEmpty(data)){
                    for (Map<String, Object> datum : data) {
                        if(!datum.isEmpty()){
                            AllocateDetailVO detailVO = new AllocateDetailVO();
                            if(null!=datum.get("userId")){
                                detailVO.setPersonnelId(Long.valueOf(String.valueOf(datum.get("userId"))));
                                detailVO.setPersonnelName(String.valueOf(datum.get("userName")));
                                detailVO.setPostName(String.valueOf(datum.get("postName")));
                                detailVOS.add(detailVO);
                            }
                        }
                    }
                }
        }else {
            throw new BusinessException("查询项目部人员失败，原因："+employeeList.getMsg());
        }
        if(CollectionUtils.isNotEmpty(detailVOS)){
            List<Long> collect = detailVOS.stream().map(t -> t.getPersonnelId()).collect(Collectors.toList());
            LambdaQueryWrapper<PersonalApproveEntity> lambdachange = Wrappers.<PersonalApproveEntity>lambdaQuery();
            lambdachange.in(PersonalApproveEntity::getApplicantId, collect);
            lambdachange.eq(PersonalApproveEntity::getDr, BaseVO.DR_UNDELETE);
            lambdachange.in(PersonalApproveEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
            List<PersonalApproveEntity> list = personalApproveService.list(lambdachange);
            if(CollectionUtils.isNotEmpty(list)){
                List<PersonalApproveVO> approveVOS = BeanMapper.mapList(list, PersonalApproveVO.class);
                for (AllocateDetailVO detailVO : detailVOS) {
                    for (PersonalApproveVO approve : approveVOS) {
                        if(detailVO.getPersonnelId().equals(approve.getApplicantId())){
                            if(StringUtils.isNotBlank(detailVO.getFhzdltIds())){
                                detailVO.setFhzdltIds(detailVO.getFhzdltIds()+","+approve.getId());
                            }else {
                                detailVO.setFhzdltIds(String.valueOf(approve.getId()));
                            }
                            AllocateApproveVO map1 = new AllocateApproveVO();
                            map1.setSourceId(approve.getId());
                            map1.setSourceCode(approve.getBillCode());
                            map1.setPersonnelId(approve.getApplicantId());
                            map1.setPersonnelName(approve.getApplicantName());
                            map1.setSourceType(approve.getApplyClauseType());
                            map1.setRowState("add");
                            List<AllocateApproveVO> allocateApproveVOS = detailVO.getAllocateApproveVOS();
                            allocateApproveVOS.add(map1);
                        }
                    }
                }
            }
        }
        map.put("detailVOS",detailVOS);
        return map;
    }

    @Override
    public AllocateVO queryDetail(Long id) {
        AllocateEntity entity = super.selectById(id);
        AllocateVO vo = BeanMapper.map(entity, AllocateVO.class);
        List<AllocateChangeVO> bgHistory = allocateMapper.getBGHistory(vo.getId());
        vo.setChangeList(bgHistory);
        List<AllocateDetailVO> detailVOS = vo.getDetailList();
        //处理孙子表信息
        List<AllocateApproveEntity> allocateApproveList = entity.getApproveList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(allocateApproveList)){
            List<AllocateApproveVO> allocateApproveVOList = BeanMapper.mapList(allocateApproveList,AllocateApproveVO.class);
            Map<Long, List<AllocateApproveVO>> bidderMap = allocateApproveVOList.stream().
                    collect(Collectors.groupingBy(AllocateApproveVO::getAllocateDetailId));
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailVOS)){
                for (AllocateDetailVO detailVO : detailVOS){
                    List<AllocateApproveVO> approveVOS = bidderMap.get(detailVO.getId());
                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(approveVOS)){
                        detailVO.setAllocateApproveVOS(approveVOS);
                    }
                }
                vo.setDetailList(detailVOS);
            }
        }
        return vo;
    }

    @Override
    public Map<String, Object> queryDetailFHZD(Long personnelId,Long projectId) {
        Map<String, Object> map = new HashMap<>();
        String fhzdltIds = null;
        List<AllocateApproveVO> allocateApproveVOS = new ArrayList<>();
        LambdaQueryWrapper<PersonalApproveEntity> lambdachange = Wrappers.<PersonalApproveEntity>lambdaQuery();
        lambdachange.eq(PersonalApproveEntity::getApplicantId, personnelId);
        lambdachange.eq(PersonalApproveEntity::getProjectId, projectId);
        lambdachange.eq(PersonalApproveEntity::getDr, BaseVO.DR_UNDELETE);
        lambdachange.in(PersonalApproveEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        List<PersonalApproveEntity> list = personalApproveService.list(lambdachange);
        if(CollectionUtils.isNotEmpty(list)){
            List<PersonalApproveVO> approveVOS = BeanMapper.mapList(list, PersonalApproveVO.class);
            for (PersonalApproveVO approve : approveVOS) {
                    if(null!=fhzdltIds){
                        fhzdltIds=fhzdltIds+","+approve.getId();
                    }else {
                        fhzdltIds=String.valueOf(approve.getId());
                    }
                AllocateApproveVO map1 = new AllocateApproveVO();
                map1.setSourceId(approve.getId());
                map1.setSourceCode(approve.getBillCode());
                map1.setPersonnelId(approve.getApplicantId());
                map1.setPersonnelName(approve.getApplicantName());
                map1.setSourceType(approve.getApplyClauseType());
                map1.setRowState("add");
                allocateApproveVOS.add(map1);
            }
        }
        map.put("personnelId",personnelId);
        map.put("fhzdltIds",fhzdltIds);
        map.put("allocateApproveVOS",allocateApproveVOS);
        return map;
    }

    @Override
    public Object excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        Long orgId = Long.valueOf(request.getParameter("orgId"));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<AllocateDetailVO> successList = new ArrayList<>();
        List<AllocateDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
//        ArrayList<AllocateDetailVO> detailVOS1 = new ArrayList<>();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        else {
            CommonResponse<List<Map<String, Object>>> employeeList = userApi.getEmployeeList(orgId);
            Map<String,Long> userIdMap = new HashMap<String,Long>();
            Map<Long,String> postNameMap = new HashMap<Long,String>();
//            ArrayList<AllocateDetailVO> detailVOS = new ArrayList<>();
            if(employeeList.isSuccess()){
                List<Map<String, Object>> data = employeeList.getData();
                if(null!=data && CollectionUtils.isNotEmpty(data)){
                    for (Map<String, Object> datum : data) {
                        if(!datum.isEmpty()){
                            AllocateDetailVO detailVO = new AllocateDetailVO();
                            if(null!=datum.get("userId") && null!=datum.get("userName")){
//                                detailVO.setPersonnelId(Long.valueOf(String.valueOf(datum.get("userId"))));
//                                detailVO.setPersonnelName(String.valueOf(datum.get("userName")));
//                                detailVO.setPostName(String.valueOf(datum.get("postName")));
//                                detailVOS1.add(detailVO);
                                userIdMap.put(String.valueOf(datum.get("userName")),Long.valueOf(String.valueOf(datum.get("userId"))));
                                postNameMap.put(Long.valueOf(String.valueOf(datum.get("userId"))),String.valueOf(datum.get("postName")));
                            }
                        }
                    }
                }
            }else {
                throw new BusinessException("查询项目部人员失败，原因："+employeeList.getMsg());
            }
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    AllocateDetailVO detailVO = new AllocateDetailVO();
                    detailVO.setId(IdWorker.getId());
                    if(StringUtils.isBlank(datas.get(0))){
                        detailVO.setErrorMsg("姓名为空！");
                        errorList.add(detailVO);
                        continue ;
                    }
                    detailVO.setPersonnelName(datas.get(0));//姓名
                    Long personnelId = userIdMap.get(datas.get(0));
                    if(null==personnelId){
                        detailVO.setErrorMsg("该人员不在当前项目下！");
                        errorList.add(detailVO);
                        continue ;
                    }
                    detailVO.setPersonnelId(personnelId);
                    detailVO.setPostName(postNameMap.get(personnelId));

//                    detailVO.setPostName(detailVO.getPostName());//岗位职务
                    try {
                        String detailRatio = datas.get(2);//比例
                        detailVO.setDetailRatio(org.apache.commons.lang3.StringUtils.isNotBlank(detailRatio)? new BigDecimal(detailRatio) : null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("风险金比例格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String shouldDetailMny = datas.get(3);//应分配额
                        if(StringUtils.isBlank(shouldDetailMny)){
                            detailVO.setErrorMsg("应预留风险金为空！");
                            errorList.add(detailVO);
                            continue;
                        }
                        detailVO.setShouldDetailMny(org.apache.commons.lang3.StringUtils.isNotBlank(shouldDetailMny) ? new BigDecimal(shouldDetailMny) : null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("应预留风险金格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String actualDetailMny = datas.get(4);//实际分配额
                        if(StringUtils.isBlank(actualDetailMny)){
                            detailVO.setErrorMsg("实际预留风险金为空！");
                            errorList.add(detailVO);
                            continue;
                        }
                        detailVO.setActualDetailMny(org.apache.commons.lang3.StringUtils.isNotBlank(actualDetailMny) ? new BigDecimal(actualDetailMny) : null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("实际预留风险金格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    detailVO.setFileIds("");
                    detailVO.setRowState("add");
                    detailVO.setBillCode(String.valueOf(new Date().getTime()));
                    detailVO.setMemo(datas.get(5));//备注
                    successList.add(detailVO);
                }
            }
            if(CollectionUtils.isNotEmpty(successList)){
                List<Long> collect = successList.stream().filter(t -> t.getPersonnelId()!=null).map(t -> t.getPersonnelId()).collect(Collectors.toList());
                LambdaQueryWrapper<PersonalApproveEntity> lambdachange = Wrappers.<PersonalApproveEntity>lambdaQuery();
                lambdachange.in(PersonalApproveEntity::getApplicantId, collect);
                lambdachange.eq(PersonalApproveEntity::getDr, BaseVO.DR_UNDELETE);
                lambdachange.in(PersonalApproveEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
                List<PersonalApproveEntity> list = personalApproveService.list(lambdachange);
                if(CollectionUtils.isNotEmpty(list)){
                    List<PersonalApproveVO> approveVOS = BeanMapper.mapList(list, PersonalApproveVO.class);
                    for (AllocateDetailVO detailVO : successList) {
                        for (PersonalApproveVO approve : approveVOS) {
                            if(null!=detailVO.getPersonnelId() && detailVO.getPersonnelId().equals(approve.getApplicantId())){
                                if(io.micrometer.core.instrument.util.StringUtils.isNotBlank(detailVO.getFhzdltIds())){
                                    detailVO.setFhzdltIds(detailVO.getFhzdltIds()+","+approve.getId());
                                }else {
                                    detailVO.setFhzdltIds(String.valueOf(approve.getId()));
                                }
                                AllocateApproveVO map1 = new AllocateApproveVO();
                                map1.setSourceId(approve.getId());
                                map1.setSourceCode(approve.getBillCode());
                                map1.setPersonnelId(approve.getApplicantId());
                                map1.setPersonnelName(approve.getApplicantName());
                                map1.setSourceType(approve.getApplyClauseType());
                                map1.setRowState("add");
                                List<AllocateApproveVO> allocateApproveVOS = detailVO.getAllocateApproveVOS();
                                allocateApproveVOS.add(map1);
                            }
                        }
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return json;
    }


}
