package com.ejianc.business.zjkjcost.reserve.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 单据类型编码常量
 */
public enum BillTypeEnum {

    主表("主表", "EJCBT202206000064"),
    变更表("变更表", "EJCBT202206000065"),
    记录表("记录表", "EJCBT202206000066"),
    主表子表("主表子表", "EJCBT202206000074"),
    变更表子表("变更表子表", "EJCBT202206000075"),
    记录表子表("记录表子表", "EJCBT202206000076"),
    ;

    private final String name;
    private final String code;
    private static Map<String, BillTypeEnum> enumMap = new HashMap();

    private BillTypeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public static BillTypeEnum getEnumByName(String billTypeName) {
        return (BillTypeEnum)enumMap.get(billTypeName);
    }

    static {
        enumMap = (Map)EnumSet.allOf(BillTypeEnum.class).stream().collect(Collectors.toMap(BillTypeEnum::getName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

}
