/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zjkjcost.reserve.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateChangeApproveEntity;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateChangeDetailEntity;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateChangeEntity;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateDetailEntity;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateEntity;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateHistoryEntity;
import com.ejianc.business.zjkjcost.reserve.bean.PersonalApproveEntity;
import com.ejianc.business.zjkjcost.reserve.enums.BillTypeEnum;
import com.ejianc.business.zjkjcost.reserve.enums.ChangeStateEnum;
import com.ejianc.business.zjkjcost.reserve.enums.ChangeTypeEnum;
import com.ejianc.business.zjkjcost.reserve.mapper.AllocateChangeMapper;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateChangeService;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateHistoryService;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateService;
import com.ejianc.business.zjkjcost.reserve.service.IPersonalApproveService;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateChangeApproveVO;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateChangeDetailVO;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateChangeVO;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateHistoryVO;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateVO;
import com.ejianc.business.zjkjcost.reserve.vo.PersonalApproveVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.micrometer.core.instrument.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="allocateChangeService")
public class AllocateChangeServiceImpl
extends BaseServiceImpl<AllocateChangeMapper, AllocateChangeEntity>
implements IAllocateChangeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPersonalApproveService personalApproveService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAllocateService allocateService;
    @Autowired
    private IAllocateHistoryService allocateHistoryService;
    private static final String BILL_CODE = "FXYLJFPBG_CODE";
    private static final String CONTRACT_FILE_SOURCE_TYPE_Z = "zjkj-allocate";
    private static final String CONTRACT_FILE_SOURCE_TYPE_BG = "zjkj-allocateChange";
    private static final String CONTRACT_FILE_SOURCE_TYPE_JL = "zjkj-allocateHistory";

    @Override
    public AllocateChangeVO saveOrUpdate(AllocateChangeVO saveOrUpdateVO) {
        AllocateChangeEntity entity;
        List detailList = saveOrUpdateVO.getDetailList();
        ArrayList<AllocateChangeApproveEntity> allocateApproveList = new ArrayList<AllocateChangeApproveEntity>();
        Map<Long, AllocateChangeApproveVO> collect = saveOrUpdateVO.getApproveList().stream().collect(Collectors.toMap(BaseVO::getId, detail -> detail, (v1, v2) -> v2));
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (AllocateChangeDetailVO detailVO : detailList) {
                List approveVOS = detailVO.getAllocateApproveVOS();
                if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)approveVOS)) continue;
                for (AllocateChangeApproveVO approveVO : approveVOS) {
                    if ("del" != detailVO.getRowState()) {
                        if (detailVO.getId() == null) {
                            long id = IdWorker.getId();
                            detailVO.setId(Long.valueOf(id));
                        }
                    } else {
                        if (null == approveVO.getId()) continue;
                        approveVO.setRowState("del");
                    }
                    if (collect.containsKey(approveVO.getId())) {
                        collect.remove(approveVO.getId());
                    }
                    approveVO.setAllocateDetailId(detailVO.getId());
                    AllocateChangeApproveEntity allocateApproveEntity = (AllocateChangeApproveEntity)((Object)BeanMapper.map((Object)approveVO, AllocateChangeApproveEntity.class));
                    allocateApproveList.add(allocateApproveEntity);
                }
            }
        }
        if (MapUtils.isNotEmpty(collect)) {
            collect.values().forEach(c -> {
                c.setRowState("del");
                allocateApproveList.add((AllocateChangeApproveEntity)((Object)BeanMapper.map((Object)c, AllocateChangeApproveEntity.class)));
            });
        }
        if ((entity = (AllocateChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AllocateChangeEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setBillCode(entity.getBillCode() + entity.getChangeVersion());
        }
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(AllocateChangeEntity::getTargetId, (Object)entity.getTargetId());
        if (entity.getId() != null) {
            lambdachange.ne(BaseEntity::getId, (Object)entity.getId());
        }
        lambdachange.notIn(AllocateChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        entity.setApproveList(allocateApproveList);
        super.saveOrUpdate((Object)entity, false);
        this.saveWriteAllocate(entity);
        AllocateChangeVO changeVO = this.queryDetail(entity.getId());
        return changeVO;
    }

    @Override
    public void delete(Long changId) {
        this.delWriteAllocate(changId);
        super.removeById((Serializable)changId, false);
    }

    private void saveWriteAllocate(AllocateChangeEntity changeEntity) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(AllocateEntity::getChangeId, (Object)changeEntity.getId());
        updateWrapper.set(AllocateEntity::getChangeCode, (Object)changeEntity.getBillCode());
        updateWrapper.set(AllocateEntity::getChangeVersion, (Object)changeEntity.getChangeVersion());
        updateWrapper.set(AllocateEntity::getChangeState, (Object)ChangeStateEnum.\u53d8\u66f4\u4e2d.getCode());
        updateWrapper.set(AllocateEntity::getChangeTime, (Object)changeEntity.getChangeTime());
        updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getTargetId());
        this.allocateService.update(this.allocateService.selectById(changeEntity.getTargetId()), (Wrapper)updateWrapper, false);
    }

    private void delWriteAllocate(Long changeId) {
        AllocateChangeEntity changeEntity = (AllocateChangeEntity)((Object)super.selectById((Serializable)changeId));
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(AllocateChangeEntity::getTargetId, (Object)changeEntity.getTargetId());
        lambdachange.eq(BaseEntity::getDr, (Object)BaseVO.DR_UNDELETE);
        lambdachange.ne(BaseEntity::getId, (Object)changeEntity.getId());
        int count = super.count((Wrapper)lambdachange);
        AllocateEntity allocateEntity = (AllocateEntity)((Object)this.allocateService.selectById(changeEntity.getTargetId()));
        allocateEntity.setChangeCode(null);
        allocateEntity.setChangeId(null);
        allocateEntity.setChangeState(count > 0 ? ChangeStateEnum.\u5df2\u53d8\u66f4.getCode() : ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
        allocateEntity.setChangeTime(null);
        allocateEntity.setChangeVersion(allocateEntity.getChangeVersion() == 1 ? null : Integer.valueOf(allocateEntity.getChangeVersion() - 1));
        this.allocateService.update((Object)allocateEntity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)allocateEntity.getId()), false);
    }

    @Override
    public AllocateChangeVO addConvertByConId(Long targetId) {
        AllocateVO allocateVO = this.allocateService.queryDetail(targetId);
        AllocateChangeVO allocateChangeVO = (AllocateChangeVO)BeanMapper.map((Object)allocateVO, AllocateChangeVO.class);
        allocateChangeVO.setBeforeShouldReserveMny(allocateChangeVO.getShouldReserveMny());
        allocateChangeVO.setBeforeActualReserveMny(allocateChangeVO.getActualReserveMny());
        allocateChangeVO.setBeforeReserveRatio(allocateChangeVO.getReserveRatio());
        allocateChangeVO.setBillState(null);
        allocateChangeVO.setTargetId(targetId);
        allocateChangeVO.setChangeVersion(Integer.valueOf(allocateVO.getChangeVersion() == null ? 1 : allocateVO.getChangeVersion() + 1));
        allocateChangeVO.setCreateUserCode(null);
        allocateChangeVO.setCreateTime(null);
        allocateChangeVO.setUpdateUserCode(null);
        allocateChangeVO.setUpdateTime(null);
        allocateChangeVO.setChangeTime(new Date());
        allocateChangeVO.setId(null);
        List allocateChangeDetailList = allocateChangeVO.getDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)allocateChangeDetailList)) {
            List collect = allocateChangeDetailList.stream().map(t -> t.getPersonnelId()).collect(Collectors.toList());
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.in(PersonalApproveEntity::getApplicantId, collect);
            lambdachange.eq(BaseEntity::getDr, (Object)BaseVO.DR_UNDELETE);
            lambdachange.in(PersonalApproveEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
            List list = this.personalApproveService.list((Wrapper)lambdachange);
            for (AllocateChangeDetailVO allocateChangeDetailVO : allocateChangeDetailList) {
                allocateChangeDetailVO.setTargetDetailId(allocateChangeDetailVO.getId());
                allocateChangeDetailVO.setBeforeDetailRatio(allocateChangeDetailVO.getDetailRatio());
                allocateChangeDetailVO.setBeforeActualDetailMny(allocateChangeDetailVO.getActualDetailMny());
                allocateChangeDetailVO.setBeforeShouldDetailMny(allocateChangeDetailVO.getShouldDetailMny());
                allocateChangeDetailVO.setChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
                allocateChangeDetailVO.setRowState("add");
                allocateChangeDetailVO.setCreateUserCode(null);
                allocateChangeDetailVO.setCreateTime(null);
                allocateChangeDetailVO.setUpdateUserCode(null);
                allocateChangeDetailVO.setUpdateTime(null);
                allocateChangeDetailVO.setFhzdltIds(null);
                ArrayList<AllocateChangeApproveVO> allocateApproveVOS = new ArrayList<AllocateChangeApproveVO>();
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)list)) {
                    List approveVOS = BeanMapper.mapList((Iterable)list, PersonalApproveVO.class);
                    for (PersonalApproveVO approve : approveVOS) {
                        if (!allocateChangeDetailVO.getPersonnelId().equals(approve.getApplicantId())) continue;
                        if (StringUtils.isNotBlank((String)allocateChangeDetailVO.getFhzdltIds())) {
                            allocateChangeDetailVO.setFhzdltIds(allocateChangeDetailVO.getFhzdltIds() + "," + approve.getId());
                        } else {
                            allocateChangeDetailVO.setFhzdltIds(String.valueOf(approve.getId()));
                        }
                        AllocateChangeApproveVO map1 = new AllocateChangeApproveVO();
                        map1.setSourceId(approve.getId());
                        map1.setSourceCode(approve.getBillCode());
                        map1.setPersonnelId(approve.getApplicantId());
                        map1.setPersonnelName(approve.getApplicantName());
                        map1.setSourceType(approve.getApplyClauseType());
                        map1.setRowState("add");
                        allocateApproveVOS.add(map1);
                    }
                }
                allocateChangeDetailVO.setAllocateApproveVOS(allocateApproveVOS);
            }
        }
        return allocateChangeVO;
    }

    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeId, String billTypeCode) {
        AllocateDetailEntity map;
        Object resp = null;
        AllocateChangeEntity changeEntity = (AllocateChangeEntity)((Object)super.selectById((Serializable)changeId));
        changeEntity.setEffectiveTime(new Date());
        super.saveOrUpdate((Object)changeEntity, false);
        this.logger.info("\u8fdb\u5165\u53d8\u66f4\u7ec8\u5ba1\uff01\u53d8\u66f4\u8868\u6570\u636e------------->: {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        AllocateVO allocateVO = this.allocateService.queryDetail(changeEntity.getTargetId());
        AllocateEntity allocateEntity = (AllocateEntity)((Object)BeanMapper.map((Object)allocateVO, AllocateEntity.class));
        AllocateHistoryVO historyVO = (AllocateHistoryVO)BeanMapper.map((Object)allocateVO, AllocateHistoryVO.class);
        historyVO.setId(null);
        historyVO.setTargetId(allocateEntity.getId());
        HashMap contIdVersionMap = new HashMap();
        this.logger.info("\u53d8\u66f4\u524d\u4e3b\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)((Object)allocateEntity)));
        this.logger.info("\u53d8\u66f4\u524d\u4e3b\u5b50\u8868detail\u6570\u636e: {}", (Object)JSONObject.toJSONString(allocateEntity.getDetailList()));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u8868\u590d\u5236\u7684\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)historyVO));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u8868\u590d\u5236\u7684\u6570\u636e\u7684\u5b50\u8868detail\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)historyVO.getDetailList()));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u8868\u590d\u5236\u7684\u6570\u636e\u7684\u5b59\u5b50\u8868\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)historyVO.getApproveList()));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)historyVO.getDetailList())) {
            ArrayList allocateApproveList = new ArrayList();
            historyVO.getDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setTargetDetailId(vo.getId());
                vo.setId(Long.valueOf(IdWorker.getId()));
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)vo.getAllocateApproveVOS())) {
                    vo.getAllocateApproveVOS().forEach(approveVO -> {
                        approveVO.setAllocateDetailId(vo.getId());
                        approveVO.setId(null);
                        allocateApproveList.add(approveVO);
                    });
                }
            });
            historyVO.setApproveList(allocateApproveList);
        }
        AllocateHistoryEntity historyEntity = (AllocateHistoryEntity)((Object)BeanMapper.map((Object)historyVO, AllocateHistoryEntity.class));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u5408\u540c\u8868\u590d\u5236\u7684\u5b50\u8868detail\u6570\u636e\uff0c\u8bbe\u7f6eid\u540e\u7684\u503c: {}", (Object)JSONObject.toJSONString((Object)historyVO.getDetailList()));
        this.allocateHistoryService.saveOrUpdate((Object)historyEntity, false);
        this.logger.info("\u5ba1\u6279-\u53d8\u66f4\u8bb0\u5f55\u8868\u4fdd\u5b58\u4e3b\u5408\u540c\u6570\u636e\u6210\u529f\uff01");
        this.copyFile(allocateEntity.getId().toString(), BillTypeEnum.\u4e3b\u8868.getCode(), CONTRACT_FILE_SOURCE_TYPE_Z, historyEntity.getId().toString(), BillTypeEnum.\u8bb0\u5f55\u8868.getCode(), CONTRACT_FILE_SOURCE_TYPE_JL, false);
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u6570\u636e\u5230\u4e3b\u6570\u636e\u8868,\u4e3b\u6570\u636e---------------->: {}", (Object)JSONObject.toJSONString((Object)((Object)allocateEntity)));
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u6570\u636e\u5230\u4e3b\u6570\u636e\u8868,\u53d8\u66f4\u6570\u636e---------------->: {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        allocateEntity.setEmployeeId(changeEntity.getEmployeeId());
        allocateEntity.setEmployeeName(changeEntity.getEmployeeName());
        allocateEntity.setEmployeeTime(changeEntity.getEmployeeTime());
        allocateEntity.setBaseReserveRatio(changeEntity.getBaseReserveRatio());
        allocateEntity.setBaseActualReserveMny(changeEntity.getBaseActualReserveMny());
        allocateEntity.setBaseShouldReserveMny(changeEntity.getBaseShouldReserveMny());
        allocateEntity.setReserveRatio(changeEntity.getReserveRatio());
        allocateEntity.setActualReserveMny(changeEntity.getActualReserveMny());
        allocateEntity.setShouldReserveMny(changeEntity.getShouldReserveMny());
        allocateEntity.setShouldBalanceMny(changeEntity.getShouldBalanceMny());
        allocateEntity.setActualBalanceMny(changeEntity.getActualBalanceMny());
        allocateEntity.setChangeState(ChangeStateEnum.\u5df2\u53d8\u66f4.getCode());
        this.copyFile(changeId.toString(), BillTypeEnum.\u53d8\u66f4\u8868.getCode(), CONTRACT_FILE_SOURCE_TYPE_BG, allocateEntity.getId().toString(), BillTypeEnum.\u4e3b\u8868.getCode(), CONTRACT_FILE_SOURCE_TYPE_Z, true);
        ArrayList<AllocateDetailEntity> saveDetailList = new ArrayList<AllocateDetailEntity>();
        List<AllocateDetailEntity> detailList = allocateEntity.getDetailList();
        List<AllocateChangeDetailEntity> detailChangeList = changeEntity.getDetailList();
        Map mapBGChang = detailChangeList.stream().filter(t -> t.getTargetDetailId() != null).collect(Collectors.toMap(AllocateChangeDetailEntity::getTargetDetailId, Function.identity()));
        Map mapADDChang = detailChangeList.stream().filter(t -> t.getTargetDetailId() == null).collect(Collectors.toMap(AllocateChangeDetailEntity::getTargetDetailId, Function.identity()));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
            for (AllocateDetailEntity detailEntity : detailList) {
                AllocateChangeDetailEntity entity = (AllocateChangeDetailEntity)((Object)mapBGChang.get(detailEntity.getId()));
                if (null == entity) {
                    detailEntity.setRowState("del");
                    saveDetailList.add(detailEntity);
                    continue;
                }
                map = (AllocateDetailEntity)((Object)BeanMapper.map((Object)((Object)entity), AllocateDetailEntity.class));
                map.setId(map.getTargetDetailId());
                map.setVersion(detailEntity.getVersion());
                map.setChangeType(null);
                map.setAllocateId(allocateEntity.getId());
                saveDetailList.add(map);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(mapADDChang.values())) {
            ArrayList values = new ArrayList(mapADDChang.values());
            for (AllocateChangeDetailEntity value : values) {
                map = (AllocateDetailEntity)((Object)BeanMapper.map((Object)((Object)value), AllocateDetailEntity.class));
                map.setId(null);
                map.setChangeType(null);
                map.setRowState("add");
                map.setAllocateId(allocateEntity.getId());
                saveDetailList.add(map);
            }
        }
        allocateEntity.setDetailList(saveDetailList);
        this.allocateService.saveOrUpdate((Object)allocateEntity, false);
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u8868\u5408\u540c\u72b6\u6001\u548c\u6570\u636e,---------->\uff1a {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        this.logger.info("\u66f4\u65b0\u4e3b\u8868\u6570\u636e\u6210\u529f,---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)allocateEntity)));
        return CommonResponse.success((String)"\u53d8\u66f4\u5355\u751f\u6548\uff0c\u56de\u5199\u5408\u540c\u6210\u529f\uff01");
    }

    @Override
    public AllocateChangeVO queryDetail(Long id) {
        List<AllocateChangeApproveEntity> allocateApproveList;
        AllocateChangeEntity changeEntity = (AllocateChangeEntity)((Object)super.selectById((Serializable)id));
        AllocateChangeVO changeVO = (AllocateChangeVO)BeanMapper.map((Object)((Object)changeEntity), AllocateChangeVO.class);
        List detailVOS = changeVO.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailVOS) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(allocateApproveList = changeEntity.getApproveList())) {
            List allocateApproveVOList = BeanMapper.mapList(allocateApproveList, AllocateChangeApproveVO.class);
            Map<Long, List<AllocateChangeApproveVO>> bidderMap = allocateApproveVOList.stream().collect(Collectors.groupingBy(AllocateChangeApproveVO::getAllocateDetailId));
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)detailVOS)) {
                for (AllocateChangeDetailVO detailVO : detailVOS) {
                    List<AllocateChangeApproveVO> approveVOS = bidderMap.get(detailVO.getId());
                    if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(approveVOS)) continue;
                    detailVO.setAllocateApproveVOS(approveVOS);
                }
                changeVO.setDetailList(detailVOS);
            }
        }
        return changeVO;
    }

    private void copyFile(String sourceBillId, String sourceBillType, String sourceBillSourceType, String targetBillId, String targetBillType, String targetBillSourceType, boolean flag) {
        CommonResponse stringCommonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(sourceBillId, sourceBillType, sourceBillSourceType, targetBillId, targetBillType, targetBillSourceType);
        if (!stringCommonResponse.isSuccess()) {
            this.logger.info("\u540c\u6b65\u9644\u4ef6\u7ba1\u7406\u4e2d\u7684\u9644\u4ef6\u5931\u8d25--------------->\u5931\u8d25\u4fe1\u606f------------>\uff1a{}", (Object)stringCommonResponse.getMsg());
        }
        this.logger.info("\u540c\u6b65\u5408\u540c\u6587\u4ef6--------------->\u540c\u6b65\u7c7b\u578b-{},sourceBillId-{},sourceBillType-{},sourceBillSourceType-{},targetBillId-{},targetBillType-{},targetBillSourceType--{},:--{}", new Object[]{flag ? "\u53d8\u66f4->\u4e3b" : "\u4e3b->\u8bb0\u5f55", sourceBillId, sourceBillType, sourceBillSourceType, targetBillId, targetBillType, targetBillSourceType, stringCommonResponse.getMsg()});
    }
}

