package com.ejianc.business.zjkjcost.optimization.service;

import com.ejianc.business.zjkjcost.optimization.vo.OptimizationRewardVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.zjkjcost.optimization.bean.OptimizationRewardEntity;

import java.util.List;

/**
 * 项目优化-项目优化奖励申请
 * 
 * @author generator
 * 
 */
public interface IOptimizationRewardService extends IBaseService<OptimizationRewardEntity> {

    /**
     * 保存数据
     *
     * @param saveOrUpdateVO 需要保存的数据
     * @return 保存后数据
     */
    OptimizationRewardVO saveData(OptimizationRewardVO saveOrUpdateVO);

    /**
     * 删除数据
     *
     * @param vos 需要删除的数据id
     */
    void deleteData(List<OptimizationRewardVO> vos);

    /**
     * 一个项目申报下只能有一个项目优化效益计算
     *
     * @param topicId 项目申报id
     * @param id      本单据id
     * @return 校验结果：true 校验失败！ false：校验通过
     */
    boolean checkOnly(Long topicId, Long id);
}
