package com.ejianc.business.zjkjcost.manage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zjkjcost.manage.bean.BookEntity;
import com.ejianc.business.zjkjcost.manage.bean.ChangeBookEntity;
import com.ejianc.business.zjkjcost.manage.bean.RecordBookEntity;
import com.ejianc.business.zjkjcost.manage.service.IBookService;
import com.ejianc.business.zjkjcost.manage.service.IChangeBookService;
import com.ejianc.business.zjkjcost.manage.service.IRecordBookService;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateEntity;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changeBook")
public class ChangeBookBpmServiceImpl implements ICommonBusinessService {


	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IChangeBookService service;

	@Autowired
	private IBookService bookService;

	@Autowired
	private IRecordBookService recordBookService;

	@Autowired
	private IAllocateService allocateService;

	@Autowired
	private IAttachmentApi attachmentApi;

	//业务类型
	private static final String Book = "zjkj-managebook";//项目目标管理责任书
	private static final String Book_CHANGE = "zjkj-changeBook";//项目目标管理责任书变更
	private static final String Book_RECORD = "zjkj-recordBook";//项目目标管理责任书变更记录

	//单据类型
	private static final String Book_BILLTYPE_CODE = "EJCBT202206000026";//项目目标管理责任书
	private static final String Book_CHANGE_BILLTYPE_CODE = "EJCBT202304000004";//项目目标管理责任书变更
	private static final String Book_RECORD_BILLTYPE_CODE = "EJCBT202304000005";//项目目标管理责任书变更记录
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ChangeBookEntity changeBookEntity = service.selectById(billId);
		List<AllocateEntity> allocateEntities = allocateService.list(new QueryWrapper<AllocateEntity>().eq("project_id", changeBookEntity.getProjectId()));
		for (AllocateEntity entity : allocateEntities) {
			entity.setShouldReserveMny(ComputeUtil.safeMultiply(changeBookEntity.getRiskFund(), new BigDecimal(10000)));
		}
		allocateService.saveBatch(allocateEntities);
		//1、获取目前单据信息、变更信息
		ChangeBookEntity changeEntity = service.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getBookId());
		BookEntity bookEntity = bookService.selectById(changeEntity.getBookId());

		//获取历史版本条数
		QueryWrapper<RecordBookEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("book_id", bookEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordBookService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordBookEntity recordBookEntity = BeanMapper.map(changeEntity, RecordBookEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordBookEntity);
		recordBookEntity.setBillState(null);
		recordBookEntity.setBookId(bookEntity.getId());
		recordBookEntity.setBookCode(bookEntity.getBillCode()+"-"+(count+1));
		recordBookEntity.setId(recordId);
		recordBookEntity.setBillCode(bookEntity.getBillCode());
		recordBookEntity.setEffectDate(new Date());

		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		sourceBillType = Book_BILLTYPE_CODE;
		String targetBillType = "";
		targetBillType = Book_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(bookEntity.getId().toString(), sourceBillType, Book , recordId.toString(), targetBillType, Book_RECORD);
		recordBookService.saveOrUpdate(recordBookEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + recordBookEntity.getCreateUserCode());
		//3、修改当前单据状态
		BookEntity bookEntity1 = BeanMapper.map(changeEntity, BookEntity.class);
		bookEntity1.setChangeState("3");//状态改为已变更
		bookEntity1.setChangeId(null);
		bookEntity1.setBillState(bookEntity.getBillState());
		bookEntity1.setId(bookEntity.getId());
		bookEntity1.setCreateTime(bookEntity.getCreateTime());
		bookEntity1.setCreateUserCode(bookEntity.getCreateUserCode());
		bookEntity1.setTenantId(bookEntity.getTenantId());
		bookEntity1.setVersion(bookEntity.getVersion());

		logger.info("---------保存--------");
		bookService.saveOrUpdate(bookEntity1, false);

		sourceBillType = Book_CHANGE_BILLTYPE_CODE;
		targetBillType = Book_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Book_CHANGE, bookEntity.getId().toString(), targetBillType, Book);
		recordBookService.saveOrUpdate(recordBookEntity, false);

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
