/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zjkjcost.reserve.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zjkjcost.reserve.bean.PersonalApproveEntity;
import com.ejianc.business.zjkjcost.reserve.service.IPersonalApproveService;
import com.ejianc.business.zjkjcost.reserve.vo.PersonalApproveVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"personalApprove"})
@Api(value="\u98ce\u9669\u9884\u7559\u91d1-\u4e2a\u4eba\u98ce\u9669\u91d1\u8fc7\u7a0b\u8fd4\u8fd8\u3001\u8f6c\u62b5\u5ba1\u6279\u8868", tags={"\u98ce\u9669\u9884\u7559\u91d1-\u4e2a\u4eba\u98ce\u9669\u91d1\u8fc7\u7a0b\u8fd4\u8fd8\u3001\u8f6c\u62b5\u5ba1\u6279\u8868"})
public class PersonalApproveController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "GRFXJSP_CODE";
    @Autowired
    private IPersonalApproveService service;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PersonalApproveVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody PersonalApproveVO saveOrUpdateVO) {
        OrgVO orgVO;
        CommonResponse orgResponse;
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
            saveOrUpdateVO.setParentOrgName(orgVO.getName());
        }
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setOrgCode(orgVO.getCode());
            saveOrUpdateVO.setOrgName(orgVO.getName());
        }
        PersonalApproveEntity entity = (PersonalApproveEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PersonalApproveEntity.class));
        List entities = new ArrayList();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PersonalApproveEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
        lambda.eq(PersonalApproveEntity::getApplicantId, (Object)saveOrUpdateVO.getApplicantId());
        if (null != saveOrUpdateVO.getId()) {
            lambda.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        }
        lambda.notIn(PersonalApproveEntity::getBillState, Arrays.asList(1, 3));
        entities = this.service.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty(entities)) {
            throw new BusinessException("\u8be5\u7533\u8bf7\u4eba\u5728\u539f\u6240\u5728\u9879\u76ee\u4e0b\u6709\u672a\u751f\u6548\u7684\u8fd4\u8fd8\u3001\u8f6c\u62b5\u5ba1\u6279\u8868\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (1 == entity.getApplyClauseType()) {
            entity.setApplyClause("\u8fd4\u8fd8");
        } else if (2 == entity.getApplyClauseType()) {
            entity.setApplyClause("\u8f6c\u62b5");
        }
        this.service.saveOrUpdate((Object)entity, false);
        PersonalApproveVO vo = (PersonalApproveVO)BeanMapper.map((Object)((Object)entity), PersonalApproveVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PersonalApproveVO> queryDetail(@RequestParam Long id) {
        PersonalApproveEntity entity = (PersonalApproveEntity)((Object)this.service.selectById(id));
        PersonalApproveVO vo = (PersonalApproveVO)BeanMapper.map((Object)((Object)entity), PersonalApproveVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u9879\u76ee\u4e0b\u662f\u5426\u6709\u6570\u636e")
    @RequestMapping(value={"/queryByProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> queryByProject(@RequestParam Long projectId, Long id, Long applicantId) {
        Boolean flag = false;
        List entities = new ArrayList();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PersonalApproveEntity::getProjectId, (Object)projectId);
        lambda.eq(PersonalApproveEntity::getApplicantId, (Object)applicantId);
        if (null != id) {
            lambda.ne(BaseEntity::getId, (Object)id);
        }
        lambda.notIn(PersonalApproveEntity::getBillState, Arrays.asList(1, 3));
        entities = this.service.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty(entities)) {
            flag = true;
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)flag);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PersonalApproveVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PersonalApproveVO personalApproveVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PersonalApproveVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List orgVOList = null;
        orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PersonalApproveVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List personalApproveVOS = BeanMapper.mapList((Iterable)list, PersonalApproveVO.class);
        for (PersonalApproveVO vo : personalApproveVOS) {
            switch (vo.getBillState()) {
                case 0: {
                    vo.setBillStateName("\u81ea\u7531\u6001");
                    break;
                }
                case 1: {
                    vo.setBillStateName("\u5df2\u63d0\u4ea4");
                    break;
                }
                case 2: {
                    vo.setBillStateName("\u5ba1\u6279\u4e2d");
                    break;
                }
                case 3: {
                    vo.setBillStateName("\u5ba1\u6279\u901a\u8fc7");
                    break;
                }
                case 4: {
                    vo.setBillStateName("\u5ba1\u6279\u9a73\u56de");
                    break;
                }
                case 5: {
                    vo.setBillStateName("\u5ba1\u6279\u4e2d");
                }
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", personalApproveVOS);
        ExcelExport.getInstance().export("PersonalApprove-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refPersonalApproveData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PersonalApproveVO>> refPersonalApproveData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PersonalApproveVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

