package com.ejianc.business.zjkjcost.manage.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.signaturemanage.api.ISignatureManageApi;
import com.ejianc.business.zjkjcost.manage.bean.BookEntity;
import com.ejianc.business.zjkjcost.manage.service.IBookService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 文件管理控制
 *
 * @author sunyj
 * @Description: 合同文件管理控制
 * @date 2022/06/26 14:16
 */
@RestController
@RequestMapping("/bookFileUpdate/")
public class BookFileController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBookService bookService;

    @Autowired
    private ISignatureManageApi signatureManageApi;


    /**
     * 附件信息更新
     *
     * @param updateData {
     *   billId 单据Id
     *   sourceType 单据业务类型
     *   billType 单据类型
     *   fileId 文件Id
     *   fileSize 文件大小（以B为单位）
     *   fileName 文件名称
     *   fileOnlinePath 文件在线预览地址
     *   imgServerPath 文件服务地址
     *   formatPathStr 文件格式化地址
     * }
     * @return
     */
    @PostMapping(value = "updateFileInfo")
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject back = new JSONObject();
        BookEntity entity = bookService.selectById(updateData.getLong("billId"));
        entity.setFileId(updateData.getLong("fileId"));
        bookService.saveOrUpdate(entity, false);
        back.put("message", "合同文件信息更新成功");
        back.put("billData", entity);
        return CommonResponse.success("合同文件信息更新成功！", back);
    }
}
