package com.ejianc.business.zjkjcost.node.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zjkjcost.finish.vo.ApproveVO;
import com.ejianc.business.zjkjcost.node.bean.NodeApprovalEntity;
import com.ejianc.business.zjkjcost.node.bean.NodeGrantDetailEntity;
import com.ejianc.business.zjkjcost.node.bean.NodeGrantEntity;
import com.ejianc.business.zjkjcost.node.service.INodeApprovalService;
import com.ejianc.business.zjkjcost.node.service.INodeGrantDetailService;
import com.ejianc.business.zjkjcost.node.service.INodeGrantService;
import com.ejianc.business.zjkjcost.node.vo.NodeGrantDetailVO;
import com.ejianc.business.zjkjcost.node.vo.NodeGrantVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 节点考核-节点目标奖金考核发放
 *
 * @author generator
 */
@Controller
@RequestMapping("nodeGrant")
@Api(value = "节点考核-节点目标奖金考核发放", tags = {"节点考核-节点目标奖金考核发放"})
public class NodeGrantController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "NODE_GRANT_CODE";//此处需要根据实际修改

    @Autowired
    private INodeGrantService service;
    @Autowired
    private INodeGrantDetailService detailService;

    @Autowired
    private INodeApprovalService nodeApprovalService;//节点考核-工程项目节点目标奖金审批service

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<NodeGrantVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody NodeGrantVO saveOrUpdateVO) {
        // parentOrgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setParentOrgCode(orgVO.getCode());

            }
        }
        if (StringUtils.isEmpty(saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setOrgCode(orgVO.getCode());
                saveOrUpdateVO.setOrgName(orgVO.getName());

            }
        }
        NodeGrantEntity entity = BeanMapper.map(saveOrUpdateVO, NodeGrantEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //金额校验：发放金额不允许大于审批金额
        checkMoney(entity);
        service.saveOrUpdate(entity, false);
        NodeGrantVO vo = BeanMapper.map(entity, NodeGrantVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * 金额校验：发放金额不允许大于审批金额
     *
     * @param entity
     */
    private void checkMoney(NodeGrantEntity entity) {
        Long contractId = entity.getContractId();//合同id
        QueryWrapper<NodeApprovalEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.in("bill_state", 1, 3);
        List<NodeApprovalEntity> nodeApprovalEntityList = nodeApprovalService.list(queryWrapper);
        if (nodeApprovalEntityList.size() == 0) {
            throw new BusinessException("该合同下没有生效的工程项目节点目标奖金审批");
        }

        //董事长审批兑现金额总金额
        BigDecimal approvalTotal = new BigDecimal(0);
        for (NodeApprovalEntity item :
                nodeApprovalEntityList) {
            //董事长审批兑现金额
            BigDecimal chairmanCashMny = item.getChairmanCashMny();
            if (chairmanCashMny != null) {
                approvalTotal = approvalTotal.add(chairmanCashMny);
            }
        }

        QueryWrapper<NodeGrantEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("dr", 0);
        queryWrapper1.eq("contract_id", contractId);

        if (entity.getId() != null && entity.getId() != 0) {
            queryWrapper1.ne("id", entity.getId());
        }
        List<NodeGrantEntity> nodeGrantEntityList = service.list(queryWrapper1);
        //实发总金额
        BigDecimal actualMnyTotal = new BigDecimal(0);
        for (NodeGrantEntity item :
                nodeGrantEntityList) {
            BigDecimal actualMny = item.getActualMny();
            if(actualMny != null){
                actualMnyTotal = actualMnyTotal.add(actualMny);
            }
        }

        BigDecimal usableMny = approvalTotal.subtract(actualMnyTotal);
        //分配金额
        BigDecimal distributionMny = entity.getDistributionMny();
        //实发金额
        BigDecimal actualMny = entity.getActualMny();
        if (distributionMny != null && distributionMny.compareTo(usableMny) > 0) {
            throw new BusinessException("分配金额不允许大于审批兑现剩余金额！");
        }
        if (actualMny != null && actualMny.compareTo(usableMny) > 0) {
            throw new BusinessException("实发金额不允许大于审批兑现剩余金额！");
        }
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<NodeGrantVO> queryDetail(@RequestParam Long id) {
        NodeGrantEntity entity = service.selectById(id);
        NodeGrantVO vo = BeanMapper.map(entity, NodeGrantVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/getGrantByContractId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<NodeGrantVO> getGrantByContractId(@RequestParam Long contractId) {
        NodeGrantVO nodeGrantVO = service.getGrantByContractId(contractId);
        return CommonResponse.success("查询详情数据成功！",nodeGrantVO);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<NodeGrantVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (NodeGrantVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(NodeGrantVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    @ApiOperation("唯一性校验")
    @RequestMapping(value = "/checkOnly", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> checkOnly(@RequestParam Long contractId, Long id) {
        return CommonResponse.success("查询数据成功！", service.checkOnly(contractId, id));
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<NodeGrantVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<NodeGrantEntity> page = service.queryPage(param, false);
        IPage<NodeGrantVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), NodeGrantVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<NodeGrantEntity> list = service.queryList(param);
        List<NodeGrantVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, NodeGrantVO.class);
            for (NodeGrantVO vo : voList) {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("NodeGrant-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refNodeGrantData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<NodeGrantVO>> refNodeGrantData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<NodeGrantEntity> page = service.queryPage(param, false);
        IPage<NodeGrantVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), NodeGrantVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadExcel")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "nodeGrant-import.xlsx", "奖金发放明细模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/uploadExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<NodeGrantDetailVO> successList = new ArrayList<>();
        List<NodeGrantDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        BigDecimal distributionMny = BigDecimal.ZERO;
        BigDecimal actualMny = BigDecimal.ZERO;
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    NodeGrantDetailVO detailVO = new NodeGrantDetailVO();
                    detailVO.setId(IdWorker.getId());
//                    detailVO.setDetailEmployeeId();
                    detailVO.setDetailEmployeeName(datas.get(0));
//                    detailVO.setDetailDepartmentId();
                    detailVO.setDetailDepartmentName(datas.get(1));
                    try {
                        String distributionMnyStr = datas.get(2);
                        detailVO.setDetailDistributionMny(StringUtils.isNotBlank(distributionMnyStr) ? new BigDecimal(distributionMnyStr) : null);
                    } catch (Exception e) {
                        detailVO.setErrorMsg("分配金额格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String actualMnyStr = datas.get(3);
                        detailVO.setDetailActualMny(StringUtils.isNotBlank(actualMnyStr) ? new BigDecimal(actualMnyStr) : null);
                    } catch (Exception e) {
                        detailVO.setErrorMsg("实发金额格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    detailVO.setDistributionSign(datas.get(4));
                    detailVO.setMemo(datas.get(5));
                    detailVO.setSourceType(1);
                    detailVO.setSourceTypeName("导入");
//                    detailVO.setGrantId();
//                    detailVO.setSourceId();
//                    detailVO.setSourceName();
                    distributionMny = distributionMny.add(this.setDefaultValue(detailVO.getDetailDistributionMny()));
                    actualMny = actualMny.add(this.setDefaultValue(detailVO.getDetailActualMny()));
                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("distributionMny", distributionMny);
        json.put("actualMny", actualMny);
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * 导出数据库数据
     *
     * @param nodeGrantVO 请求
     * @param response    请求
     */
    @RequestMapping(value = "/excelExportFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMaterialFromDatabase(@RequestBody NodeGrantVO nodeGrantVO, HttpServletResponse response) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("grantId", new Parameter(QueryParam.EQ, nodeGrantVO.getId()));
        List<NodeGrantDetailEntity> list = detailService.queryList(queryParam);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("nodeGrantDetail-export.xlsx", beans, response);
    }

    /**
     * 导出列表数据
     *
     * @param list     列表
     * @param response 请求
     */
    @RequestMapping(value = "/excelExportFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMaterialFromPage(@RequestBody List<NodeGrantDetailVO> list,
                                            HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("nodeGrantDetail-export.xlsx", beans, response);
    }

    /**
     * 赋值默认值0
     *
     * @param v v
     * @return 默认值
     */
    private BigDecimal setDefaultValue(BigDecimal v) {
        if (v == null) return BigDecimal.ZERO;
        return v;
    }
}
