package com.ejianc.business.zjkjcost.finish.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zjkjcost.finish.vo.ApplyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.checkerframework.checker.units.qual.A;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zjkjcost.finish.mapper.ApplyMapper;
import com.ejianc.business.zjkjcost.finish.bean.ApplyEntity;
import com.ejianc.business.zjkjcost.finish.service.IApplyService;

import java.util.ArrayList;
import java.util.List;

/**
 * 竣工考核-目标责任书竣工考核兑现申报-主表
 * 
 * @author generator
 * 
 */
@Service("applyService")
public class ApplyServiceImpl extends BaseServiceImpl<ApplyMapper, ApplyEntity> implements IApplyService{

    @Override
    public ApplyVO getApplyByContractId(Long contractId) {
        List<Integer> statusList = new ArrayList<>();
        statusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        statusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        LambdaQueryWrapper<ApplyEntity> lambda = Wrappers.<ApplyEntity>lambdaQuery();
        lambda.eq(ApplyEntity::getContractId, contractId);
        lambda.in(ApplyEntity::getBillState, statusList);

        List<ApplyEntity> list = super.list(lambda);
        ApplyEntity applyEntity = new ApplyEntity();
        if (CollectionUtils.isNotEmpty(list)){
            applyEntity = list.get(0);
        }
        return BeanMapper.map(applyEntity,ApplyVO.class);
    }
}
