/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zjkjcost.node.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zjkjcost.node.bean.NodeGrantEntity;
import com.ejianc.business.zjkjcost.node.mapper.NodeGrantMapper;
import com.ejianc.business.zjkjcost.node.service.INodeGrantService;
import com.ejianc.business.zjkjcost.node.vo.NodeGrantVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="nodeGrantService")
public class NodeGrantServiceImpl
extends BaseServiceImpl<NodeGrantMapper, NodeGrantEntity>
implements INodeGrantService {
    @Override
    public boolean checkOnly(Long contractId, Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("billState", new Parameter("not_in", Arrays.asList(1, 3)));
        if (id != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)id));
        }
        return CollectionUtils.isNotEmpty((Collection)super.queryList(queryParam, false));
    }

    @Override
    public NodeGrantVO getGrantByContractId(Long contractId) {
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        statusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(NodeGrantEntity::getContractId, (Object)contractId);
        lambda.in(NodeGrantEntity::getBillState, statusList);
        List list = super.list((Wrapper)lambda);
        NodeGrantEntity nodeGrantEntity = new NodeGrantEntity();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)list)) {
            nodeGrantEntity = (NodeGrantEntity)((Object)list.get(0));
        }
        return (NodeGrantVO)BeanMapper.map((Object)((Object)nodeGrantEntity), NodeGrantVO.class);
    }

    @Override
    public boolean checkApprovalOnly(Long nodeApprovalId, Long id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(NodeGrantEntity::getNodeApprovalId, (Object)nodeApprovalId);
        queryWrapper.ne(null != id, BaseEntity::getId, (Object)id);
        return this.count((Wrapper)queryWrapper) > 0;
    }
}

