/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zjkjcost.manage.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zjkjcost.manage.bean.BookEntity;
import com.ejianc.business.zjkjcost.manage.service.IBookService;
import com.ejianc.business.zjkjcost.manage.service.IRecordBookService;
import com.ejianc.business.zjkjcost.manage.vo.BookVO;
import com.ejianc.business.zjkjcost.manage.vo.IncontractVO;
import com.ejianc.business.zjkjcost.manage.vo.RecordBookVO;
import com.ejianc.foundation.costmanage.api.CostanalysisApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"book"})
@Api(value="\u9879\u76ee\u76ee\u6807\u7ba1\u7406\u8d23\u4efb\u4e66", tags={"\u9879\u76ee\u76ee\u6807\u7ba1\u7406\u8d23\u4efb\u4e66"})
public class BookController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private CostanalysisApi costanalysisApi;
    private static final String BILL_CODE = "COST_BOOK";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBookService service;
    @Autowired
    private IRecordBookService recordBookService;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BookVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody BookVO saveOrUpdateVO) {
        BookEntity entity = (BookEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BookEntity.class));
        List entities = new ArrayList();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BookEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
        lambda.notIn(BookEntity::getBillState, Arrays.asList(1, 3));
        if (null != saveOrUpdateVO.getId()) {
            lambda.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        }
        entities = this.service.list((Wrapper)lambda);
        this.checkResponsibility(entity.getProjectId());
        if (CollectionUtils.isNotEmpty(entities)) {
            throw new BusinessException("\u8be5\u9879\u76ee\u4e0b\u5df2\u7ecf\u5b58\u5728\u9879\u76ee\u76ee\u6807\u7ba1\u7406\u8d23\u4efb\u4e66\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setChangeState("1");
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        BookVO vo = (BookVO)BeanMapper.map((Object)((Object)entity), BookVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BookVO> queryDetail(@RequestParam Long id) {
        BookEntity entity = (BookEntity)((Object)this.service.selectById(id));
        BookVO vo = (BookVO)BeanMapper.map((Object)((Object)entity), BookVO.class);
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"book_id", (Object)vo.getId());
            List records = this.recordBookService.list((Wrapper)queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordBookVOList(BeanMapper.mapList((Iterable)records, RecordBookVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryCopyDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BookVO> queryCopyDetail(@RequestParam Long id) {
        BookEntity entity = (BookEntity)((Object)this.service.selectById(id));
        BookVO bookVO = (BookVO)BeanMapper.map((Object)((Object)entity), BookVO.class);
        bookVO.setId(null);
        bookVO.setBillState(null);
        bookVO.setCreateUserCode(null);
        bookVO.setCreateTime(null);
        bookVO.setUpdateUserCode(null);
        bookVO.setUpdateTime(null);
        bookVO.setBillCode(null);
        bookVO.setIsChange(Integer.valueOf(0));
        return CommonResponse.success((Object)bookVO);
    }

    @RequestMapping(value={"/queryContractId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<IncontractVO>> queryContractId(@RequestParam Long projectId) {
        List<IncontractVO> vo = this.service.queryContract(projectId);
        return CommonResponse.success(vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u9879\u76ee\u4e0b\u662f\u5426\u6709\u6570\u636e")
    @RequestMapping(value={"/queryByProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> queryByProject(@RequestParam Long projectId, Long id) {
        Boolean flag = false;
        List entities = new ArrayList();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BookEntity::getProjectId, (Object)projectId);
        lambda.notIn(BookEntity::getBillState, Arrays.asList(1, 3));
        if (null != id) {
            lambda.ne(BaseEntity::getId, (Object)id);
        }
        if (CollectionUtils.isNotEmpty(entities = this.service.list((Wrapper)lambda))) {
            flag = true;
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)flag);
    }

    private void checkResponsibility(Long projectId) {
        CommonResponse subcontracts = this.costanalysisApi.isResponsibilitycost(projectId);
        if (subcontracts.getCode() == 0) {
            if ((Integer)subcontracts.getData() == 0) {
                throw new BusinessException("\u5148\u521b\u5efa\u8d23\u4efb\u6210\u672c");
            }
            return;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/queryResponsibilityByProject"}, method={RequestMethod.GET})
    public CommonResponse<BookEntity> queryResponsibilityByProject(@RequestParam Long projectId) {
        BookEntity entity = new BookEntity();
        entity.setResponsibilityCost((BigDecimal)this.costanalysisApi.queryResponsibilitycost(projectId).getData());
        BookVO vo = this.service.queryTurninBase(projectId);
        entity.setTurninBase(vo.getTurninBase());
        entity.setPreBid(vo.getPreBid());
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", (Object)((Object)entity));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BookVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (BookVO bookVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BookVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        for (BookEntity entity : page.getRecords()) {
            entity.setZbContractMny(ComputeUtil.safeDiv((BigDecimal)entity.getZbContractMny(), (BigDecimal)BigDecimal.valueOf(10000L)));
            entity.setZsContractMny(ComputeUtil.safeDiv((BigDecimal)entity.getZsContractMny(), (BigDecimal)BigDecimal.valueOf(10000L)));
        }
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BookVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(p -> p.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)p.getBillState()).getDescription()));
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("Book-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refBookData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BookVO>> refBookData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BookVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u6821\u9a8c\u9879\u76ee\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u9879\u76ee\u76ee\u6807\u8d23\u4efb\u4e66")
    @RequestMapping(value={"/checkHasBook"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> queryBook(@RequestParam(value="projectId") Long projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.isNull((Object)"is_change");
        int count = this.service.count((Wrapper)queryWrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)(count == 0 ? 1 : 0));
    }
}

