/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zjkjcost.optimization.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.zjkjcost.optimization.bean.OptimizationCalculationEntity;
import com.ejianc.business.zjkjcost.optimization.bean.OptimizationRewardEntity;
import com.ejianc.business.zjkjcost.optimization.enums.OccupyFlagEnum;
import com.ejianc.business.zjkjcost.optimization.enums.OccupyTypeEnum;
import com.ejianc.business.zjkjcost.optimization.mapper.OptimizationRewardMapper;
import com.ejianc.business.zjkjcost.optimization.service.IOptimizationCalculationService;
import com.ejianc.business.zjkjcost.optimization.service.IOptimizationRewardService;
import com.ejianc.business.zjkjcost.optimization.service.IOptimizationTopicService;
import com.ejianc.business.zjkjcost.optimization.vo.OptimizationRewardVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="optimizationRewardService")
public class OptimizationRewardServiceImpl
extends BaseServiceImpl<OptimizationRewardMapper, OptimizationRewardEntity>
implements IOptimizationRewardService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOptimizationTopicService topicService;
    @Autowired
    private IOptimizationCalculationService optimizationCalculationService;
    private static final String BILL_CODE = "OPTIMIZATION_REWARD_CODE";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OptimizationRewardVO saveData(OptimizationRewardVO saveOrUpdateVO) {
        OptimizationRewardEntity entity;
        boolean flag;
        OrgVO orgVO;
        CommonResponse orgResponse;
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setOrgCode(orgVO.getCode());
            saveOrUpdateVO.setOrgName(orgVO.getName());
        }
        if (flag = this.checkOnly((entity = (OptimizationRewardEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OptimizationRewardEntity.class))).getTopicId(), entity.getId())) {
            throw new BusinessException("\u8be5\u9879\u76ee\u4f18\u5316\u7acb\u9879\u7533\u62a5\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        boolean ocuFlag = true;
        if (entity.getId() != null) {
            OptimizationRewardEntity oldEntity = (OptimizationRewardEntity)((Object)super.selectById((Serializable)entity.getId()));
            if (oldEntity.getTopicId().equals(entity.getTopicId())) {
                ocuFlag = false;
            }
            if (ocuFlag) {
                this.topicService.updateOccupyFlagByTopicId(oldEntity.getTopicId(), OccupyFlagEnum.\u672a\u5360\u7528.getCode(), OccupyTypeEnum.\u9879\u76ee\u4f18\u5316\u5956\u52b1\u7533\u8bf7.getCode());
            }
        }
        if (ocuFlag) {
            this.topicService.updateOccupyFlagByTopicId(entity.getTopicId(), OccupyFlagEnum.\u5df2\u5360\u7528.getCode(), OccupyTypeEnum.\u9879\u76ee\u4f18\u5316\u5956\u52b1\u7533\u8bf7.getCode());
        }
        super.saveOrUpdate((Object)entity, false);
        return (OptimizationRewardVO)BeanMapper.map((Object)((Object)entity), OptimizationRewardVO.class);
    }

    @Override
    public void deleteData(List<OptimizationRewardVO> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        List list = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        List<Long> topicIdList = list.stream().map(OptimizationRewardEntity::getTopicId).collect(Collectors.toList());
        this.topicService.updateOccupyFlagByTopicIds(topicIdList, OccupyFlagEnum.\u672a\u5360\u7528.getCode(), OccupyTypeEnum.\u9879\u76ee\u4f18\u5316\u5956\u52b1\u7533\u8bf7.getCode());
        super.removeByIds(ids, true);
    }

    @Override
    public boolean checkOnly(Long topicId, Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("topicId", new Parameter("eq", (Object)topicId));
        if (id != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)id));
        }
        List list = super.queryList(queryParam, false);
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    @Override
    public OptimizationRewardVO checkOnlyNew(Long topicId, Long id) {
        OptimizationRewardVO rewardVO = new OptimizationRewardVO();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(OptimizationCalculationEntity::getTopicId, (Object)topicId);
        queryWrapper.in(OptimizationCalculationEntity::getBillState, new Object[]{"1,3"});
        List calculationEntities = this.optimizationCalculationService.list((Wrapper)queryWrapper);
        rewardVO.setCalcId(((OptimizationCalculationEntity)((Object)calculationEntities.get(0))).getId());
        rewardVO.setCalcCode(((OptimizationCalculationEntity)((Object)calculationEntities.get(0))).getBillCode());
        return rewardVO;
    }
}

