package com.ejianc.business.zjkjcost.optimization.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum OccupyFlagEnum {

    /**
     * 项目优化立项申报占用状态：0、未占用；
     */
    未占用(0, "未占用"),

    /**
     * 项目优化立项申报占用状态：1、已占用；
     */
    已占用(1, "已占用");


    private Integer code;
    private String description;
    private static Map<Integer, OccupyFlagEnum> enumMap = new HashMap<>();

    OccupyFlagEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(OccupyFlagEnum.class).stream().collect(Collectors
                .toMap(OccupyFlagEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static OccupyFlagEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }
}
