package com.ejianc.business.zjkjcost.finish.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zjkjcost.finish.bean.ApplyDetailEntity;
import com.ejianc.business.zjkjcost.finish.bean.ApproveEntity;
import com.ejianc.business.zjkjcost.finish.bean.OutDetailEntity;
import com.ejianc.business.zjkjcost.finish.service.IOutDetailService;
import com.ejianc.business.zjkjcost.finish.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.zjkjcost.finish.bean.OutEntity;
import com.ejianc.business.zjkjcost.finish.service.IOutService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 竣工考核-竣工目标考核奖金发放-主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("out")
@Api(value = "竣工考核-竣工目标考核奖金发放-主表", tags = {"竣工考核-竣工目标考核奖金发放-主表"})
public class OutController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOutDetailService outDetailService;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZJKJ_FINISH_OUT";//此处需要根据实际修改

    @Autowired
    private IOutService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody OutVO saveOrUpdateVO) {
    	OutEntity entity = BeanMapper.map(saveOrUpdateVO, OutEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	OutVO vo = BeanMapper.map(entity, OutVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/getOutByContractId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutVO> getOutByContractId(@RequestParam Long contractId) {
        OutVO outVO = service.getOutByContractId(contractId);
        return CommonResponse.success("查询详情数据成功！",outVO);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutVO> queryDetail(@RequestParam Long id) {
    	OutEntity entity = service.selectById(id);
    	OutVO vo = BeanMapper.map(entity, OutVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OutVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OutVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<OutEntity> page = service.queryPage(param,false);
        IPage<OutVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        List<OutEntity> list = service.queryList(param);
        List<OutVO> listVo = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)){
            listVo = BeanMapper.mapList(list, OutVO.class);
            for (OutVO outVO : listVo){
                outVO.setBillStateName(BillStateEnum.getEnumByStateCode(outVO.getBillState()).getDescription());
            }
        }

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listVo);
        ExcelExport.getInstance().export("Out-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refOutData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutVO>> refOutData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OutEntity> page = service.queryPage(param,false);
        IPage<OutVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    @ApiOperation("查询合同下是否有数据")
    @RequestMapping(value = "/queryByContractId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> queryByContractId(@RequestParam Long contractId,Long id) {
        Boolean flag = false; //代表合同下没数据
        List<OutEntity> entities = new ArrayList<>();
        LambdaQueryWrapper<OutEntity> lambda = Wrappers.<OutEntity>lambdaQuery();
        lambda.eq(OutEntity::getContractId, contractId);
        if(null!=id){
            lambda.ne(OutEntity::getId,id);
        }
        entities = service.list(lambda);
        if(CollectionUtils.isNotEmpty(entities)){
            flag = true;  //代表合同下有数据
        }
        return CommonResponse.success("查询数据成功！",flag);
    }
    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/uploadExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<OutDetailVO> successList = new ArrayList<>();
        List<OutDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        BigDecimal distributionMny = BigDecimal.ZERO;
        BigDecimal actualMny = BigDecimal.ZERO;
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    OutDetailVO detailVO = new OutDetailVO();
                    detailVO.setId(IdWorker.getId());
                    detailVO.setUserName(datas.get(0));
                    detailVO.setJob(datas.get(1));
                    try {
                        String detailOutMny = datas.get(2);
                        detailVO.setDetailOutMny(StringUtils.isNotBlank(detailOutMny) ? new BigDecimal(detailOutMny) : null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("分配金额格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String detailActualMny = datas.get(3);
                        detailVO.setDetailActualMny(StringUtils.isNotBlank(detailActualMny) ? new BigDecimal(detailActualMny) : null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("实发金额格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    if (detailVO.getDetailActualMny().compareTo(detailVO.getDetailOutMny()) == 1) {
                        detailVO.setErrorMsg("实发金额格大于分配金额！");
                        errorList.add(detailVO);
                        continue;
                    }
                    detailVO.setSign(datas.get(4));
                    detailVO.setMemo(datas.get(5));
                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("distributionMny", distributionMny);
        json.put("actualMny", actualMny);
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadExcel")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "out-detail-import.xlsx", "考核兑现详情模板");
    }

    /**
     * 导出数据库数据
     *
     * @param response    请求
     */
    @RequestMapping(value = "/excelExportFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMaterialFromDatabase(@RequestBody OutVO outVO, HttpServletResponse response) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("outId", new Parameter(QueryParam.EQ, outVO.getId()));
        List<OutDetailEntity> list = outDetailService.queryList(queryParam);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outDetail-export.xlsx", beans, response);
    }

    /**
     * 导出列表数据
     *
     * @param list     列表
     * @param response 请求
     */
    @RequestMapping(value = "/excelExportFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMaterialFromPage(@RequestBody List<OutDetailVO> list,
                                            HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outDetail-export.xlsx", beans, response);
    }
}
