/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zjkjcost.reserve.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zjkjcost.manage.bean.BookEntity;
import com.ejianc.business.zjkjcost.manage.bean.ChangeBookEntity;
import com.ejianc.business.zjkjcost.manage.service.IBookService;
import com.ejianc.business.zjkjcost.manage.service.IChangeBookService;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateDetailEntity;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateEntity;
import com.ejianc.business.zjkjcost.reserve.bean.PersonalApproveEntity;
import com.ejianc.business.zjkjcost.reserve.enums.ChangeStateEnum;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateChangeDetailService;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateDetailService;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateHistoryDetailService;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateHistoryService;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateService;
import com.ejianc.business.zjkjcost.reserve.service.IDepartmentApproveService;
import com.ejianc.business.zjkjcost.reserve.service.IPersonalApproveService;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateDetailVO;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateExportVO;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateHistoryVO;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"allocate"})
@Api(value="\u98ce\u9669\u9884\u7559\u91d1-\u9879\u76ee\u90e8\u4eba\u5458\u98ce\u9669\u91d1\u9884\u7559\u5206\u914d\u8868", tags={"\u98ce\u9669\u9884\u7559\u91d1-\u9879\u76ee\u90e8\u4eba\u5458\u98ce\u9669\u91d1\u9884\u7559\u5206\u914d\u8868"})
public class AllocateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IZjkjProjectApi zjkjProjectApi;
    private static final String BILL_CODE = "FXYLJFP_CODE";
    @Autowired
    private IAllocateService service;
    @Autowired
    private IAllocateDetailService allocateDetailService;
    @Autowired
    private IAllocateChangeDetailService allocateChangeDetailService;
    @Autowired
    private IAllocateHistoryDetailService allocateHistoryDetailService;
    @Autowired
    private IAllocateHistoryService historyService;
    @Autowired
    private IPersonalApproveService personalApproveService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBookService bookService;
    @Autowired
    private IChangeBookService changeBookService;
    @Autowired
    private IDepartmentApproveService departmentApproveService;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AllocateVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody AllocateVO saveOrUpdateVO) {
        CommonResponse projectVOCommonResponse;
        String innerCode;
        String[] strs;
        CommonResponse orgVos;
        CommonResponse orgVo;
        List list = saveOrUpdateVO.getDetailList();
        BigDecimal total = new BigDecimal(0);
        if (list.size() > 0 && saveOrUpdateVO.getShouldReserveMny() != null) {
            for (AllocateDetailVO allocateDetailVO : list) {
                if (allocateDetailVO.getShouldDetailMny() == null) continue;
                if (allocateDetailVO.getRowState() == null) {
                    total = total.add(allocateDetailVO.getShouldDetailMny());
                    continue;
                }
                if (allocateDetailVO.getRowState().equals("del")) continue;
                total = total.add(allocateDetailVO.getShouldDetailMny());
            }
            total = total.setScale(2, 4);
            this.logger.info("total" + total);
            this.logger.info("shouldReserveMny" + saveOrUpdateVO.getShouldReserveMny());
            if (total.compareTo(saveOrUpdateVO.getShouldReserveMny()) != 0) {
                this.logger.info("boolean" + total.compareTo(saveOrUpdateVO.getShouldReserveMny()));
                return CommonResponse.error((String)"\u4eba\u5458\u5217\u8868\u4e0b\u5e94\u9884\u7559\u98ce\u9669\u91d1\u4e0d\u7b49\u4e8e\u8868\u5934\uff0c\u8bf7\u4fee\u6539\u91d1\u989d\uff01");
            }
        }
        if ((orgVo = this.iOrgApi.detailById(saveOrUpdateVO.getOrgId())).isSuccess() && null != orgVo.getData() && (orgVos = this.iOrgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() && null != orgVos.getData()) {
            saveOrUpdateVO.setOrgStatusOrder(Integer.valueOf(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence()));
        }
        if (!(projectVOCommonResponse = this.zjkjProjectApi.queryDetailById(saveOrUpdateVO.getProjectId())).isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25");
        }
        ProjectVO projectVO = (ProjectVO)projectVOCommonResponse.getData();
        saveOrUpdateVO.setProjectCreateTime(projectVO.getCreateTime());
        AllocateVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AllocateVO> queryDetail(@RequestParam Long id) {
        AllocateVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryLastDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AllocateVO> queryLastDetail(Long projectId, Date month, Long id) {
        List entityList = this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).notIn(id != null, (Object)"id", new Object[]{id})).orderByDesc((Object)"month")).last("limit 1"));
        AllocateVO vo = new AllocateVO();
        List detailList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            for (AllocateEntity entity : entityList) {
                detailList = this.allocateDetailService.list((Wrapper)new QueryWrapper().eq((Object)"allocate_id", (Object)entity.getId()));
                vo = (AllocateVO)BeanMapper.map((Object)((Object)entity), AllocateVO.class);
            }
            for (AllocateDetailEntity detailEntity : detailList) {
                detailEntity.setId(IdWorker.getId());
            }
            vo.setDetailList(BeanMapper.mapList(detailList, AllocateDetailVO.class));
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
        }
        return null;
    }

    @ApiOperation(value="\u67e5\u8be2\u9879\u76ee\u6821\u9a8c/\u5b50\u8868")
    @RequestMapping(value={"/getProjectUser"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, Object>> getProjectUser(@RequestParam Long projectId, Long orgId, Long id) {
        Map<String, Object> map = this.service.getProjectUser(projectId, orgId, id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", map);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u4eba\u5458\u8fd4\u8fd8/\u8f6c\u62b5")
    @RequestMapping(value={"/queryDetailFHZD"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, Object>> queryDetailFHZD(@RequestParam Long personnelId, @RequestParam Long projectId) {
        Map<String, Object> map = this.service.queryDetailFHZD(personnelId, projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", map);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AllocateVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AllocateVO allocateVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u9879\u76ee\u4e0b\u662f\u5426\u6709\u6570\u636e")
    @RequestMapping(value={"/isThereData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> isThereData(@RequestParam Long projectId, Long id) {
        Boolean flag = false;
        List entities = new ArrayList();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(AllocateEntity::getProjectId, (Object)projectId);
        if (null != id) {
            lambda.ne(BaseEntity::getId, (Object)id);
        }
        if (CollectionUtils.isNotEmpty(entities = this.service.list((Wrapper)lambda))) {
            flag = true;
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)flag);
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AllocateVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        param.getOrderMap().put("org_status_order", "asc");
        param.getOrderMap().put("project_create_time", "asc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AllocateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExportFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportMaterialFromDatabase(@RequestBody Map<String, Object> map, HttpServletResponse response) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("allocateId", new Parameter("eq", (Object)Long.valueOf(String.valueOf(map.get("id")))));
        List allocateDetailVOS = new ArrayList();
        switch (Integer.valueOf(String.valueOf(map.get("type")))) {
            case 1: {
                allocateDetailVOS = BeanMapper.mapList((Iterable)this.allocateDetailService.queryList(queryParam), AllocateDetailVO.class);
                break;
            }
            case 2: {
                allocateDetailVOS = BeanMapper.mapList((Iterable)this.allocateChangeDetailService.queryList(queryParam), AllocateDetailVO.class);
                break;
            }
            case 3: {
                allocateDetailVOS = BeanMapper.mapList((Iterable)this.allocateHistoryDetailService.queryList(queryParam), AllocateDetailVO.class);
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", allocateDetailVOS);
        ExcelExport.getInstance().export("AllocateDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportMaterialFromPage(@RequestBody List<AllocateDetailVO> list, HttpServletResponse response) {
        HashMap<String, List<AllocateDetailVO>> beans = new HashMap<String, List<AllocateDetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("AllocateDetail-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap beans = new HashMap();
        ArrayList<AllocateExportVO> voList = new ArrayList<AllocateExportVO>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (AllocateEntity val : list) {
                AllocateExportVO vo = (AllocateExportVO)BeanMapper.map((Object)((Object)val), AllocateExportVO.class);
                if (val.getCreateTime() != null) {
                    vo.setCreateTime(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)val.getCreateTime()));
                }
                if (val.getMonth() != null) {
                    vo.setMonth(DateFormatUtil.formatDate((String)"yyyy-MM", (Date)val.getMonth()));
                }
                if (val.getShouldReserveMny() != null) {
                    vo.setShouldReserveMny(val.getShouldReserveMny().setScale(2, 4) + "");
                }
                if (val.getActualReserveMny() != null) {
                    vo.setActualReserveMny(val.getActualReserveMny().setScale(2, 4) + "");
                }
                if (val.getShouldBalanceMny() != null) {
                    vo.setShouldBalanceMny(val.getShouldBalanceMny().setScale(2, 4) + "");
                }
                if (val.getActualBalanceMny() != null) {
                    vo.setActualBalanceMny(val.getActualBalanceMny().setScale(2, 4) + "");
                }
                vo.setChangeState(ChangeStateEnum.getEnumByCode(val.getChangeState()).getDescription());
                vo.setBillState(BillStateEnum.getEnumByStateCode((Integer)val.getBillState()).getDescription());
                voList.add(vo);
            }
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("Allocate-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refAllocateData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AllocateVO>> refAllocateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AllocateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadExcel"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"AllocateDetail-import.xlsx", (String)"\u4eba\u5458\u5217\u8868\u6a21\u677f");
    }

    @RequestMapping(value={"/uploadExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        Object o = this.service.excelImportMaterial(request, response);
        return CommonResponse.success((Object)o);
    }

    @ApiOperation(value="\u67e5\u8be2\u8f6c\u62b5\u3001\u8fd4\u8fd8\u91d1\u989d")
    @RequestMapping(value={"/moneyResult"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> moneyResult(@RequestParam Long projectId, @RequestParam Long id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"applicant_id", (Object)id);
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        List list = this.personalApproveService.list((Wrapper)queryWrapper);
        BigDecimal generalRemortgageMnyTotal = null;
        for (int i = 0; i < list.size(); ++i) {
            PersonalApproveEntity personalApproveEntity = (PersonalApproveEntity)((Object)list.get(i));
            BigDecimal generalRemortgageMny = personalApproveEntity.getGeneralRemortgageMny();
            generalRemortgageMnyTotal = generalRemortgageMny.add(generalRemortgageMny);
        }
        return CommonResponse.success(generalRemortgageMnyTotal);
    }

    @ApiOperation(value="\u67e5\u8be2\u9879\u76ee\u76ee\u6807\u7ba1\u7406\u8d23\u4efb\u4e66")
    @RequestMapping(value={"/queryBook"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryBook(@RequestParam(value="projectId") Long projectId) {
        BigDecimal total = BigDecimal.ZERO;
        List bookEntityList = this.bookService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).in((Object)"bill_state", new Object[]{1, 3})).orderByDesc((Object)"create_time"));
        if (CollectionUtils.isNotEmpty((Collection)bookEntityList)) {
            List changeBookEntityList;
            total = ((BookEntity)((Object)bookEntityList.get(0))).getChangeState().equals("1") ? ((BookEntity)((Object)bookEntityList.get(0))).getRiskFund() : (CollectionUtils.isNotEmpty((Collection)(changeBookEntityList = this.changeBookService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"book_id", (Object)((BookEntity)((Object)bookEntityList.get(0))).getId())).in((Object)"bill_state", new Object[]{1, 3})).orderByDesc((Object)"create_time")))) ? ((ChangeBookEntity)((Object)changeBookEntityList.get(0))).getRiskFund() : ((BookEntity)((Object)bookEntityList.get(0))).getRiskFund());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)total);
    }

    @ApiOperation(value="\u67e5\u8be2\u9879\u76ee\u90e8\u4eba\u5458\u98ce\u9669\u91d1\u9884\u7559\u5206\u914d\u8868")
    @RequestMapping(value={"/queryAllocate"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean queryAllocate(@RequestParam(value="projectId") Long projectId, @RequestParam(value="id") Long id) {
        List allocateEntityList = this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).notIn((Object)"bill_state", new Object[]{1, 3})).notIn(id != null, (Object)"id", new Object[]{id}));
        Boolean flag = false;
        if (CollectionUtils.isNotEmpty((Collection)allocateEntityList)) {
            flag = true;
        }
        return flag;
    }

    @ApiOperation(value="\u67e5\u8be2\u9879\u76ee\u90e8\u9884\u7559\u91d1\u8fd4\u8fd8\u5ba1\u6279\u8868")
    @RequestMapping(value={"/queryDepartmentApprove"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean queryDepartmentApprove(@RequestParam(value="projectId") Long projectId) {
        List departmentApproveEntityList = this.departmentApproveService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).notIn((Object)"bill_state", new Object[]{1, 3}));
        Boolean flag = false;
        if (CollectionUtils.isNotEmpty((Collection)departmentApproveEntityList)) {
            flag = true;
        }
        return flag;
    }

    @ApiOperation(value="\u67e5\u8be2\u5386\u53f2\u7248\u672c")
    @RequestMapping(value={"/queryHistroy"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<AllocateHistoryVO>> queryHistroy(@RequestParam(value="targetId") Long targetId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"target_id", (Object)targetId);
        List list = this.historyService.list((Wrapper)queryWrapper);
        List allocateHistoryVOS = BeanMapper.mapList((Iterable)list, AllocateHistoryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)allocateHistoryVOS);
    }
}

