package com.ejianc.business.zjkjcost.reserve.service.impl;

import cn.hutool.json.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateDetailEntity;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateEntity;
import com.ejianc.business.zjkjcost.reserve.bean.PersonalApproveEntity;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateDetailService;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateService;
import com.ejianc.business.zjkjcost.reserve.service.IPersonalApproveService;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("personalApprove")
public class PersonalApproveBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPersonalApproveService service;
    @Autowired
    private IZjkjProjectApi zjkjProjectApi;

    @Autowired
    private IPersonalApproveService personalApproveService;

    @Autowired
    private IAllocateService allocateService;

    @Autowired
    private IAllocateDetailService allocateDetailService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //审批完之后根据项目，申请人去查个人风险金的表，将总经理的应返还金额返回
//        backAllocate(billId, state, billTypeCode);



//        QueryWrapper<PersonalApproveEntity> queryWrapper = new QueryWrapper<>();
//        queryWrapper.eq("project_id", projectId);
//        queryWrapper.eq("applicant_id", applicantId);
//        queryWrapper.eq("dr", 0);
//        queryWrapper.in("bill_state", 1,3);
//        List<PersonalApproveEntity> list = personalApproveService.list(queryWrapper);
//
//        for (PersonalApproveEntity personalApproveEntity : list) {
//            if(billId.equals(personalApproveEntity.getId())){
//                generalRemortgageMny = personalApproveEntity.getGeneralRemortgageMny();//总经理审批金额
//            }
//        }


        return CommonResponse.success();
    }

    /**
     * 回写项目部预留金分配表
     * @param billId
     * @param state
     * @param billTypeCode
     */
    private void backAllocate(Long billId, Integer state, String billTypeCode) {
        logger.info("个人风险预留金审批表终审......");
        if(state.equals(3) || state.equals(1)){
            PersonalApproveEntity personalApproveEntity1 = personalApproveService.selectById(billId);
            BigDecimal generalRemortgageMny = personalApproveEntity1.getGeneralRemortgageMny();//总经理审批金额

            Long projectId = personalApproveEntity1.getProjectId();
            Long applicantId = personalApproveEntity1.getApplicantId();//申请人
            logger.info("申请人id：" + applicantId);
            String applyClauseType = personalApproveEntity1.getApplyClause();//申请事项
            logger.info("申请事项：" + applyClauseType);

            //查询项目部人员风险金预留分配表
            QueryWrapper<AllocateEntity> queryWrapper1 = new QueryWrapper<>();
            queryWrapper1.eq("project_id", projectId);
            //queryWrapper.eq("applicant_id",applicantId);
            queryWrapper1.eq("dr", 0);
            queryWrapper1.in("bill_state", 1,3);
            List<AllocateEntity> list1 = allocateService.list(queryWrapper1);
            logger.info("查询项目部人员风险金预留分配表" + list1.size());
            if (list1 != null && list1.size() > 0) {
                java.lang.Long mid = list1.get(0).getId();
                AllocateEntity allocateEntities = allocateService.selectById(mid);
                List<AllocateDetailEntity> detailList = allocateEntities.getDetailList();
                logger.info("项目部人员风险金预留分配表子表" + detailList.size());
                for (AllocateDetailEntity allocateDetail : detailList) {
                    Long personnelId = allocateDetail.getPersonnelId();
                    if (personnelId !=null && personnelId.equals(applicantId)){
                        if ("返还".equals(applyClauseType)) {
                            allocateDetail.setReturnMortgageMny(generalRemortgageMny); //返还的总经理审批金额
                            BigDecimal shouldDetailMny = allocateDetail.getShouldDetailMny() != null ? allocateDetail.getShouldDetailMny() : new BigDecimal(0);//应预留风险金（元）
                            BigDecimal actualDetailMny = allocateDetail.getActualDetailMny() != null ? allocateDetail.getActualDetailMny() : new BigDecimal(0);//实际预留风险金（元）
                            BigDecimal returnMortgageMnies = allocateDetail.getReturnMortgageMny() != null ? allocateDetail.getReturnMortgageMny() : new BigDecimal(0);//返还金额
                            BigDecimal shouldSubtracts = shouldDetailMny.subtract(returnMortgageMnies);//应预留风险金（元）-返还金额
                            BigDecimal actualAubtract = actualDetailMny.subtract(returnMortgageMnies);//实际预留风险金（元）-返还金额
                            BigDecimal mortgageMnies = allocateDetail.getMortgageMny() != null ? allocateDetail.getMortgageMny() : new BigDecimal(0);//转抵金额
                            //应预留风险金余额
                            allocateDetail.setShouldBalanceMny(shouldSubtracts.subtract(mortgageMnies));
                            //实际预留风险金余额
                            allocateDetail.setActualBalanceMny(actualAubtract.subtract(mortgageMnies));
                        } else if ("转抵".equals(applyClauseType)){
                            allocateDetail.setMortgageMny(generalRemortgageMny); //转抵的总经理审批金额
                            BigDecimal shouldDetailMny = allocateDetail.getShouldDetailMny() != null ? allocateDetail.getShouldDetailMny() : new BigDecimal(0);//应预留风险金（元）
                            BigDecimal actualDetailMny = allocateDetail.getActualDetailMny() != null ? allocateDetail.getActualDetailMny() : new BigDecimal(0);//实际预留风险金（元）
                            BigDecimal returnMortgageMnies = allocateDetail.getReturnMortgageMny() != null ? allocateDetail.getReturnMortgageMny() : new BigDecimal(0);//返还金额
                            BigDecimal shouldSubtracts = shouldDetailMny.subtract(returnMortgageMnies);//应预留风险金（元）-返还金额
                            BigDecimal actualAubtract = actualDetailMny.subtract(returnMortgageMnies);//实际预留风险金（元）-返还金额
                            BigDecimal mortgageMnies = allocateDetail.getMortgageMny() != null ? allocateDetail.getMortgageMny() : new BigDecimal(0);//转抵金额
                            //应预留风险金余额
                            allocateDetail.setShouldBalanceMny(shouldSubtracts.subtract(mortgageMnies));
                            //实际预留风险金余额
                            allocateDetail.setActualBalanceMny(actualAubtract.subtract(mortgageMnies));
                        }else{
                            BigDecimal shouldDetailMny = allocateDetail.getShouldDetailMny() != null ? allocateDetail.getShouldDetailMny() : new BigDecimal(0);//应预留风险金（元）
                            BigDecimal actualDetailMny = allocateDetail.getActualDetailMny() != null ? allocateDetail.getActualDetailMny() : new BigDecimal(0);//实际预留风险金（元）
                            BigDecimal returnMortgageMnies = allocateDetail.getReturnMortgageMny() != null ? allocateDetail.getReturnMortgageMny() : new BigDecimal(0);//返还金额
                            BigDecimal shouldSubtracts = shouldDetailMny.subtract(returnMortgageMnies);//应预留风险金（元）-返还金额
                            BigDecimal actualAubtract = actualDetailMny.subtract(returnMortgageMnies);//实际预留风险金（元）-返还金额
                            BigDecimal mortgageMnies = allocateDetail.getMortgageMny() != null ? allocateDetail.getMortgageMny() : new BigDecimal(0);//转抵金额
                            //应预留风险金余额
                            allocateDetail.setShouldBalanceMny(shouldSubtracts.subtract(mortgageMnies));
                            //实际预留风险金余额
                            allocateDetail.setActualBalanceMny(actualAubtract.subtract(mortgageMnies));
                        }
                    }
                }
                allocateDetailService.saveOrUpdateBatch(detailList);
            }
        }
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *  个人风险金过程返还、转抵审批表终审逻辑
     *  汇总此项目下的此人员的个人风险金过程返还、转抵审批表的返还和转抵金额
     *  回填到此项目下的项目部人员风险金预留分配表中的此人员下的子表的转抵和返还金额字段 并计算余额金额字段
     *  然后汇总此项目下的项目部人员风险金预留分配表的子表余额字段到表头中
     *  然后一次返回所有个人风险金过程返还、转抵审批表的跳转连接
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PersonalApproveEntity entity = service.selectById(billId);
        //查询项目部人员风险金预留分配表的单据
        AllocateEntity allocateEntity = allocateService.getOne(new QueryWrapper<AllocateEntity>().eq("project_id", entity.getProjectId()).in("bill_state", 1, 3).orderByDesc("create_time").last("limit 1"));
        if(allocateEntity == null){
            throw new BusinessException("该项目没有生效的项目部人员风险金预留分配表数据!");
        }

        //查询项目部人员风险金预留分配表子表数据
        List<AllocateDetailEntity> allocateDetailEntityList = allocateDetailService.list(new QueryWrapper<AllocateDetailEntity>().eq("allocate_id",allocateEntity.getId()));

        //查询这个项目下和这个申请人下的返还和转抵表的主键id集合
        List<Map<String, String>> billCodes = service.selectIds(entity.getProjectId(), entity.getApplyId());
        if (billCodes.isEmpty()){
            Map<String, String> idMap = new HashMap<>();
            idMap.put("sourceCode",entity.getBillCode());
            idMap.put("sourceId",entity.getId().toString());
            idMap.put("sourceType",entity.getApplyClauseType().toString());
            billCodes.add(idMap);
        }
        //表头 应预留风险金额余额  shouldBalanceMny  实际预留风险金额余额  actualBalanceMny
        //表体 应预留风险金余额（元） shouldBalanceMny  实际预留风险金余额（元） actualBalanceMny
        BigDecimal shouldBalanceMny = BigDecimal.ZERO;
        BigDecimal actualBalanceMny = BigDecimal.ZERO;
      //  shouldBalanceMny = ComputeUtil.safeAdd(allocateDetailEntity.getMortgageMny(),entity.getGeneralRemortgageMny());
        for (AllocateDetailEntity allocateDetailEntity : allocateDetailEntityList) {
            if (entity.getApplicantId().equals(allocateDetailEntity.getId())) {
                if (entity.getApplyClauseType() == 1) { // 返还
                    allocateDetailEntity.setReturnMortgageMny(ComputeUtil.safeAdd(allocateDetailEntity.getReturnMortgageMny(), entity.getGeneralRemortgageMny()));
                } else { // 转抵
                    allocateDetailEntity.setMortgageMny(ComputeUtil.safeAdd(allocateDetailEntity.getMortgageMny(),entity.getGeneralRemortgageMny()));
                }
                JSONArray jsonArray = new JSONArray(billCodes);
                allocateDetailEntity.setFhzdltIds(jsonArray.toString());
            }

            allocateDetailEntity.setShouldBalanceMny(ComputeUtil.safeSub(allocateDetailEntity.getShouldDetailMny(),allocateDetailEntity.getReturnMortgageMny(),allocateDetailEntity.getMortgageMny(),allocateDetailEntity.getOrgReturnMortgageMny()));
            allocateDetailEntity.setActualBalanceMny(ComputeUtil.safeSub(allocateDetailEntity.getActualDetailMny(),allocateDetailEntity.getReturnMortgageMny(),allocateDetailEntity.getMortgageMny(),allocateDetailEntity.getOrgReturnMortgageMny()));
            shouldBalanceMny = ComputeUtil.safeAdd(allocateDetailEntity.getShouldBalanceMny(),shouldBalanceMny);
            actualBalanceMny = ComputeUtil.safeAdd(allocateDetailEntity.getActualBalanceMny(),actualBalanceMny);
        }
        allocateEntity.setShouldBalanceMny(shouldBalanceMny);
        allocateEntity.setActualBalanceMny(actualBalanceMny);
        allocateService.saveOrUpdate(allocateEntity);
        allocateDetailService.saveOrUpdateBatch(allocateDetailEntityList);
        return CommonResponse.success();
    }


    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
//        CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
//        logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
//        if (!res.isSuccess()) {
//            return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
//        }
        //TODO
        return CommonResponse.error("该功能不支持");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
         if(!resp.isSuccess()){
         return CommonResponse.error("无法撤回！"+resp.getMsg());
         }*/
        return CommonResponse.success();
    }

}
