package com.ejianc.business.zjkjcost.reserve.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.zjkjcost.reserve.bean.AllocateDetailEntity;
/**
 * 风险预留金-项目部人员风险金预留分配表
 *
 * @author generator
 *
 */
 @TableName("ejc_zjkjcost_reserve_allocate")
public class AllocateEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="org_id")
    private Long orgId; // 项目部
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 组织组织编码
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="employee_time")
    private Date employeeTime; // 经办时间
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="base_should_reserve_mny")
    private BigDecimal baseShouldReserveMny; // 初始应预留风险金额
    @TableField(value="base_actual_reserve_mny")
    private BigDecimal baseActualReserveMny; // 初始实际预留风险金额
    @TableField(value="base_reserve_ratio")
    private BigDecimal baseReserveRatio; // 初始预留风险比例
    @TableField(value="should_reserve_mny")
    private BigDecimal shouldReserveMny; // 应预留风险金额
    @TableField(value="actual_reserve_mny")
    private BigDecimal actualReserveMny; // 实际预留风险金额
    @TableField(value="reserve_ratio")
    private BigDecimal reserveRatio; // 预留风险比例
    @TableField(value="before_should_reserve_mny")
    private BigDecimal beforeShouldReserveMny; // 变更前应预留风险金额
    @TableField(value="before_actual_reserve_mny")
    private BigDecimal beforeActualReserveMny; // 变更前实际预留风险金额
    @TableField(value="before_reserve_ratio")
    private BigDecimal beforeReserveRatio; // 变更前预留风险比例
    @TableField(value="change_state")
    private Integer changeState; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="change_id")
    private Long changeId; // 最新变更单id
    @TableField(value="target_id")
    private Long targetId; // 原单据主键
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="change_time")
    private Date changeTime; // 变更时间
    @TableField(value="change_code")
    private String changeCode; // 变更编号
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="effective_time")
    private Date effectiveTime; // 生效时间
    @TableField(value="should_balance_mny")
    private BigDecimal shouldBalanceMny; // 应预留风险金额余额
    @TableField(value="actual_balance_mny")
    private BigDecimal actualBalanceMny; // 实际预留风险金额余额
    @TableField(value="month")
    private Date month; // 月份
    @TableField(value="project_status")
    private String projectStatus;  // 项目状态：1-未开工, 2-在建，3-完工，4-停缓建， 5-竣工未结算， 6-竣工已结算

    @TableField(value="project_create_time")
    private Date projectCreateTime; // 项目创建日期
    @TableField(value="org_status_order")
    private Integer orgStatusOrder; // 二级组织排序

    @TableField(exist=false)
    @SubEntity(serviceName="allocateDetailService",pidName = "allocateId")//此处有pid="xxx"，默认值pid="pid"
    private List<AllocateDetailEntity> detailList = new ArrayList<>(); // 风险预留金-项目部人员风险金预留分配表子表

    @TableField(exist=false)
    @SubEntity(serviceName="allocateApproveService",pidName = "allocateId")//此处有pid="xxx"，默认值pid="pid"
    private List<AllocateApproveEntity> approveList = new ArrayList<>(); // 风险预留金-项目部人员风险金预留分配表孙子表

    public Date getProjectCreateTime() {
        return projectCreateTime;
    }

    public void setProjectCreateTime(Date projectCreateTime) {
        this.projectCreateTime = projectCreateTime;
    }

    public Integer getOrgStatusOrder() {
        return orgStatusOrder;
    }

    public void setOrgStatusOrder(Integer orgStatusOrder) {
        this.orgStatusOrder = orgStatusOrder;
    }

    public List<AllocateApproveEntity> getApproveList() {
        return approveList;
    }

    public void setApproveList(List<AllocateApproveEntity> approveList) {
        this.approveList = approveList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getEmployeeTime() {
        return employeeTime;
    }

    public void setEmployeeTime(Date employeeTime) {
        this.employeeTime = employeeTime;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public BigDecimal getBaseShouldReserveMny() {
        return baseShouldReserveMny;
    }

    public void setBaseShouldReserveMny(BigDecimal baseShouldReserveMny) {
        this.baseShouldReserveMny = baseShouldReserveMny;
    }
    public BigDecimal getBaseActualReserveMny() {
        return baseActualReserveMny;
    }

    public void setBaseActualReserveMny(BigDecimal baseActualReserveMny) {
        this.baseActualReserveMny = baseActualReserveMny;
    }
    public BigDecimal getBaseReserveRatio() {
        return baseReserveRatio;
    }

    public void setBaseReserveRatio(BigDecimal baseReserveRatio) {
        this.baseReserveRatio = baseReserveRatio;
    }
    public BigDecimal getShouldReserveMny() {
        return shouldReserveMny;
    }

    public void setShouldReserveMny(BigDecimal shouldReserveMny) {
        this.shouldReserveMny = shouldReserveMny;
    }
    public BigDecimal getActualReserveMny() {
        return actualReserveMny;
    }

    public void setActualReserveMny(BigDecimal actualReserveMny) {
        this.actualReserveMny = actualReserveMny;
    }
    public BigDecimal getReserveRatio() {
        return reserveRatio;
    }

    public void setReserveRatio(BigDecimal reserveRatio) {
        this.reserveRatio = reserveRatio;
    }
    public BigDecimal getBeforeShouldReserveMny() {
        return beforeShouldReserveMny;
    }

    public void setBeforeShouldReserveMny(BigDecimal beforeShouldReserveMny) {
        this.beforeShouldReserveMny = beforeShouldReserveMny;
    }
    public BigDecimal getBeforeActualReserveMny() {
        return beforeActualReserveMny;
    }

    public void setBeforeActualReserveMny(BigDecimal beforeActualReserveMny) {
        this.beforeActualReserveMny = beforeActualReserveMny;
    }
    public BigDecimal getBeforeReserveRatio() {
        return beforeReserveRatio;
    }

    public void setBeforeReserveRatio(BigDecimal beforeReserveRatio) {
        this.beforeReserveRatio = beforeReserveRatio;
    }
    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Long getTargetId() {
        return targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public Date getChangeTime() {
        return changeTime;
    }

    public void setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }
    public List<AllocateDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<AllocateDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public BigDecimal getShouldBalanceMny() {
        return shouldBalanceMny;
    }

    public void setShouldBalanceMny(BigDecimal shouldBalanceMny) {
        this.shouldBalanceMny = shouldBalanceMny;
    }

    public BigDecimal getActualBalanceMny() {
        return actualBalanceMny;
    }

    public void setActualBalanceMny(BigDecimal actualBalanceMny) {
        this.actualBalanceMny = actualBalanceMny;
    }

    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }

    public String getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }
}
