package com.ejianc.business.zjkjcost.optimization.service;

import com.ejianc.business.zjkjcost.optimization.vo.OptimizationCalculationVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.zjkjcost.optimization.bean.OptimizationCalculationEntity;

import java.util.List;

/**
 * 项目优化-项目优化效益计算
 *
 * @author generator
 */
public interface IOptimizationCalculationService extends IBaseService<OptimizationCalculationEntity> {

    /**
     * 保存数据
     *
     * @param saveOrUpdateVO 需要保存的数据
     * @return 保存后数据
     */
    OptimizationCalculationVO saveData(OptimizationCalculationVO saveOrUpdateVO);

    /**
     * 删除数据
     *
     * @param vos 需要删除的数据id
     */
    void deleteData(List<OptimizationCalculationVO> vos);

    /**
     * 一个项目申报下只能有一个项目优化效益计算
     *
     * @param topicId 项目申报id
     * @param id      本单据id
     * @return 校验结果：true 校验失败！ false：校验通过
     */
    boolean checkOnly(Long topicId, Long id);
}
