package com.ejianc.business.zjkjcost.manage.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zjkjcost.manage.bean.BookEntity;
import com.ejianc.business.zjkjcost.manage.bean.RecordBookEntity;
import com.ejianc.business.zjkjcost.manage.service.IBookService;
import com.ejianc.business.zjkjcost.manage.service.IRecordBookService;
import com.ejianc.business.zjkjcost.manage.vo.BookVO;
import com.ejianc.business.zjkjcost.manage.vo.IncontractVO;
import com.ejianc.business.zjkjcost.manage.vo.RecordBookVO;
import com.ejianc.business.zjkjcost.node.bean.NodeApprovalEntity;
import com.ejianc.foundation.costmanage.api.CostanalysisApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目目标管理责任书
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("book")
@Api(value = "项目目标管理责任书", tags = {"项目目标管理责任书"})
public class BookController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private CostanalysisApi costanalysisApi;

    private static final String BILL_CODE = "COST_BOOK";//此处需要根据实际修改
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBookService service;
    @Autowired
    private IRecordBookService recordBookService;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BookVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody BookVO saveOrUpdateVO) {
    	BookEntity entity = BeanMapper.map(saveOrUpdateVO, BookEntity.class);
        List<BookEntity> entities = new ArrayList<>();
        LambdaQueryWrapper<BookEntity> lambda = Wrappers.<BookEntity>lambdaQuery();
        lambda.eq(BookEntity::getProjectId, saveOrUpdateVO.getProjectId());
        lambda.notIn(BookEntity::getBillState,Arrays.asList(1, 3));
        if(null!=saveOrUpdateVO.getId()){
            lambda.ne(BookEntity::getId,saveOrUpdateVO.getId());
        }
        entities = service.list(lambda);

        //校验：查询项目下是否有责任成本
        checkResponsibility(entity.getProjectId());

        if(CollectionUtils.isNotEmpty(entities)){
            throw new BusinessException("该项目下已经存在项目目标管理责任书，不允许新增!");
        }
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setChangeState("1");//未变更
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	BookVO vo = BeanMapper.map(entity, BookVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/changeTime", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BookVO> changeTime(@RequestBody BookVO bookVO){
        LambdaUpdateWrapper<BookEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BookEntity::getId, bookVO.getId());
        updateWrapper.set(BookEntity::getSignTime, bookVO.getSignTime());
        service.update(updateWrapper);
        BookEntity bookEntity = service.selectById(bookVO.getId());
        BookVO vo = BeanMapper.map(bookEntity, BookVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BookVO> queryDetail(@RequestParam Long id) {
    	BookEntity entity = service.selectById(id);
    	BookVO vo = BeanMapper.map(entity, BookVO.class);
        //当前单据变更过则显示变更记录
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper<RecordBookEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("book_id", vo.getId());
            List<RecordBookEntity> records = recordBookService.list(queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordBookVOList(BeanMapper.mapList(records, RecordBookVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 复制新增
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryCopyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BookVO> queryCopyDetail(@RequestParam Long id) {
        BookEntity entity = service.selectById(id);
        BookVO bookVO = BeanMapper.map(entity, BookVO.class);
        //新增即点变更按钮穿透过来，此时ID为合同id
        //标记是否变更
        bookVO.setId(null);
        bookVO.setBillState(null);
        bookVO.setCreateUserCode(null);
        bookVO.setCreateTime(null);
        bookVO.setUpdateUserCode(null);
        bookVO.setUpdateTime(null);
        bookVO.setBillCode(null);
        bookVO.setIsChange(0);
        return CommonResponse.success(bookVO);
    }

    @RequestMapping(value = "/queryContractId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<IncontractVO>> queryContractId(@RequestParam Long projectId) {
        List<IncontractVO> vo = service.queryContract(projectId);
        return CommonResponse.success(vo);
    }

    @ApiOperation("查询项目下是否有数据")
    @RequestMapping(value = "/queryByProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> queryByProject(@RequestParam Long projectId,Long id) {
        Boolean flag = false; //代表项目下没数据
        List<BookEntity> entities = new ArrayList<>();
        LambdaQueryWrapper<BookEntity> lambda = Wrappers.<BookEntity>lambdaQuery();
        lambda.eq(BookEntity::getProjectId, projectId);
        lambda.notIn(BookEntity::getBillState,Arrays.asList(1, 3));
        if(null!=id){
            lambda.ne(BookEntity::getId,id);
        }
        entities = service.list(lambda);
        if(CollectionUtils.isNotEmpty(entities)){
            flag = true;  //代表项目下有数据
        }
        return CommonResponse.success("查询数据成功！",flag);
    }

    /**
     * 查询项目下是否有责任成本
     * @param
     * @param projectId
     */
    private void checkResponsibility(Long projectId) {
        CommonResponse<Integer> subcontracts = costanalysisApi.isResponsibilitycost(projectId);
        if (subcontracts.getCode() == 0){
            if (subcontracts.getData() == 0){
                throw new BusinessException("先创建责任成本");
            }else{
                return;
            }
        }
    }

    /**
     * 责任成本
     * @param
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/queryResponsibilityByProject", method = RequestMethod.GET)
    public CommonResponse<BookEntity> queryResponsibilityByProject(@RequestParam Long projectId){
        BookEntity entity = new BookEntity();
        //responsibilityCost;  责任成本(不含税成本)
        entity.setResponsibilityCost(costanalysisApi.queryResponsibilitycost(projectId).getData());
        // 查询责任成本的产值收入
        BookVO vo = service.queryTurninBase(projectId);
        entity.setTurninBase(vo.getTurninBase());
        entity.setPreBid(vo.getPreBid());
        return CommonResponse.success("查询数据成功",entity);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BookVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (BookVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(BookVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BookVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //* 数据隔离 本下 没有组织orgId的删除下面代码-------------开始
        UserContext userContextCache =sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<BookEntity> page = service.queryPage(param,false);
        IPage<BookVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BookVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BookEntity> list = service.queryList(param);

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        if (CollectionUtils.isNotEmpty(list)){
            list.forEach(p -> p.setBillStateName(BillStateEnum.getEnumByStateCode(p.getBillState()).getDescription()));
        }


        beans.put("records", list);
        ExcelExport.getInstance().export("Book-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refBookData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BookVO>> refBookData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<BookEntity> page = service.queryPage(param,false);
        IPage<BookVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BookVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    @ApiOperation("校验项目是否已经存在项目目标责任书")
    @RequestMapping(value = "/checkHasBook", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> queryBook(@RequestParam(value = "projectId") Long projectId) {
        QueryWrapper<BookEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.isNull("is_change");
        int count = service.count(queryWrapper);
        return CommonResponse.success("查询成功", count == 0);
    }
}
