package com.ejianc.business.fill.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 日进度计划填报
 *
 * @author generator
 */
public class DayFillVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private Long projectControlLevel; // 项目管控级别(自定义档案)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date fillDate; // 填报日期
    private Long fillUserId; // 填报人主键
    private String fillUserName; // 填报人名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateDate; // 修改时间
    private Long updateUserId; // 修改人主键
    private String updateUserName; // 修改人名称
    private Integer finishFlag; // 是否按时完成(≥0时按时完成，<0时延期多少天)
    private Integer billState; // 单据状态
    private String billCode; // 单据编号
    private Long sourceId; // 执行计划单据主键
    private String calendarUid; // 日历主键
    private String calendars; // 日历
    private Boolean importFlag; // 是否导入
    private Integer fillVersion;// 反馈版本
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date filterDate;// 筛选日期
    private BigDecimal days; //预警相差天数

    public Date getFilterDate() {
        return filterDate;
    }

    public void setFilterDate(Date filterDate) {
        this.filterDate = filterDate;
    }

    private List<DayFillDetailVO> progressDetailList = new ArrayList<>();

    private List<DayFillDetailVO> removedTasks = new ArrayList<>();

    private List<DayFillDetailVO> tasks = new ArrayList<>();

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Long getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
    }

    @Override
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public List<DayFillDetailVO> getProgressDetailList() {
        return progressDetailList;
    }

    public void setProgressDetailList(List<DayFillDetailVO> progressDetailList) {
        this.progressDetailList = progressDetailList;
    }

    public List<DayFillDetailVO> getRemovedTasks() {
        return removedTasks;
    }

    public void setRemovedTasks(List<DayFillDetailVO> removedTasks) {
        this.removedTasks = removedTasks;
    }

    public List<DayFillDetailVO> getTasks() {
        return tasks;
    }

    public void setTasks(List<DayFillDetailVO> tasks) {
        this.tasks = tasks;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getProjectControlLevel() {
        return projectControlLevel;
    }
    @ReferDeserialTransfer
    public void setProjectControlLevel(Long projectControlLevel) {
        this.projectControlLevel = projectControlLevel;
    }

    public Date getFillDate() {
        return fillDate;
    }

    public void setFillDate(Date fillDate) {
        this.fillDate = fillDate;
    }

    public Long getFillUserId() {
        return fillUserId;
    }

    public void setFillUserId(Long fillUserId) {
        this.fillUserId = fillUserId;
    }

    public String getFillUserName() {
        return fillUserName;
    }

    public void setFillUserName(String fillUserName) {
        this.fillUserName = fillUserName;
    }

    public Integer getFinishFlag() {
        return finishFlag;
    }

    public void setFinishFlag(Integer finishFlag) {
        this.finishFlag = finishFlag;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getCalendarUid() {
        return calendarUid;
    }

    public void setCalendarUid(String calendarUid) {
        this.calendarUid = calendarUid;
    }

    public String getCalendars() {
        return calendars;
    }

    public void setCalendars(String calendars) {
        this.calendars = calendars;
    }

    public Integer getFillVersion() {
        return fillVersion;
    }

    public void setFillVersion(Integer fillVersion) {
        this.fillVersion = fillVersion;
    }

    public BigDecimal getDays() {
        return days;
    }

    public void setDays(BigDecimal days) {
        this.days = days;
    }
}
