package com.ejianc.business.plan.vo;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 年计划变更详情
 * 
 * @author generator
 * 
 */
public class YearPlanDetailChangeVO extends BaseDetailVO {
    private static final long serialVersionUID = 1L;
    
    private Long yearId; // 总计划主键
    private Long yearBid; // 主表主键
    private Long progressId; // 主表主键
    private Integer taskLine; // 任务条线(手续线、设计线、建造线、招采线)
    private Integer nodeLevel; // 节点级别
    private Long employeeId; // 负责人主键
    private String employeeName; // 负责人名称
    private BigDecimal planNum; // 工程量
    private Integer unit; // 单位(枚举格式， 包含：㎡、m、m3、kg、t、个)
    private String resourceName; // 资源名称
    private Integer type; // 资源类型(劳动力、材料、机械)
    private Integer typeUnit; // 资源单位(㎡、m、m3、kg、t、个、台班、工日)
    private BigDecimal needNum; // 需求量
    private Integer changeType; // 变更类型,0-未变更,1-变更项,2-新增项
    private Integer planState; // 任务标识
    private Long sourceBid; // 执行计划明细主键
    private Long sourceId; // 执行计划单据主键

    private List<YearPlanDetailChangeVO> children = new ArrayList<>();// 子任务

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private Date predictFinish; // 预测完成日期

    public Date getPredictFinish() {
        return predictFinish;
    }

    public void setPredictFinish(Date predictFinish) {
        this.predictFinish = predictFinish;
    }

    private Boolean useState; // 是否日反馈引用

    public Boolean getUseState() {
        return useState;
    }

    public void setUseState(Boolean useState) {
        this.useState = useState;
    }

    public Long getYearId() {
        return yearId;
    }

    public void setYearId(Long yearId) {
        this.yearId = yearId;
    }

    public Long getYearBid() {
        return yearBid;
    }

    public void setYearBid(Long yearBid) {
        this.yearBid = yearBid;
    }

    public Long getProgressId() {
        return progressId;
    }

    public void setProgressId(Long progressId) {
        this.progressId = progressId;
    }

    public Integer getTaskLine() {
        return taskLine;
    }

    public void setTaskLine(Integer taskLine) {
        this.taskLine = taskLine;
    }

    public Integer getNodeLevel() {
        return nodeLevel;
    }

    public void setNodeLevel(Integer nodeLevel) {
        this.nodeLevel = nodeLevel;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getTypeUnit() {
        return typeUnit;
    }

    public void setTypeUnit(Integer typeUnit) {
        this.typeUnit = typeUnit;
    }

    public BigDecimal getNeedNum() {
        return needNum;
    }

    public void setNeedNum(BigDecimal needNum) {
        this.needNum = needNum;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public Integer getPlanState() {
        return planState;
    }

    public void setPlanState(Integer planState) {
        this.planState = planState;
    }

    public Long getSourceBid() {
        return sourceBid;
    }

    public void setSourceBid(Long sourceBid) {
        this.sourceBid = sourceBid;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public List<YearPlanDetailChangeVO> getChildren() {
        return children;
    }

    public void setChildren(List<YearPlanDetailChangeVO> children) {
        this.children = children;
    }
}
