package com.ejianc.business.plan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 年计划
 * 
 * @author generator
 * 
 */
public class YearPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private Long corpId; // 区域公司
    private String corpCode; // 区域公司编码
    private String corpName; // 区域公司名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planBeginDate; // 计划开始日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planEndDate; // 计划结束日期
    private Integer planYear; // 计划年度
    private Long projectManagerId; // 项目经理主键
    private String projectManagerName; // 项目经理名称
    private Long projectControlLevel; // 项目管控级别(自定义档案)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 开工时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitTime; // 审批提交时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date approvedTime; // 审批完成时间
    private Integer finishFlag; // 是否按时完成(≥0时按时完成，<0时延期多少天)
    private Integer changeVersion; // 计划版本
    private Long changeId; // 变更主键
    private String changeCode; // 变更单号
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date changeApprovedTime; // 更新时间(变更单审批完成时间)
    private Long changeReason; // 变更原因
    private String changeDescription; // 变更描述
    private Integer billState; // 单据状态
    private String billCode; // 单据编号
    private Long sourceId; // 执行计划单据主键
    private String calendarUid; // 日历主键
    private String calendars; // 日历
    private String changeStatusName; // 变更状态
    private String changeVersionName; // 计划版本
    private Boolean importFlag; // 是否导入
    private BigDecimal days; //预警相差天数

    private List<YearPlanDetailVO> allList = new ArrayList<>();

    private List<YearPlanDetailVO> progressDetailList = new ArrayList<>();

    private List<YearPlanDetailVO> removedTasks = new ArrayList<>();

    private List<YearPlanDetailVO> tasks = new ArrayList<>();

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }
    public String getCorpCode() {
        return corpCode;
    }

    public void setCorpCode(String corpCode) {
        this.corpCode = corpCode;
    }
    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }
    public Date getPlanBeginDate() {
        return planBeginDate;
    }

    public void setPlanBeginDate(Date planBeginDate) {
        this.planBeginDate = planBeginDate;
    }
    public Date getPlanEndDate() {
        return planEndDate;
    }

    public void setPlanEndDate(Date planEndDate) {
        this.planEndDate = planEndDate;
    }
    public Integer getPlanYear() {
        return planYear;
    }

    public void setPlanYear(Integer planYear) {
        this.planYear = planYear;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectManagerId() {
        return projectManagerId;
    }
    @ReferDeserialTransfer
    public void setProjectManagerId(Long projectManagerId) {
        this.projectManagerId = projectManagerId;
    }
    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getProjectControlLevel() {
        return projectControlLevel;
    }
    @ReferDeserialTransfer
    public void setProjectControlLevel(Long projectControlLevel) {
        this.projectControlLevel = projectControlLevel;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getCommitTime() {
        return commitTime;
    }

    public void setCommitTime(Date commitTime) {
        this.commitTime = commitTime;
    }
    public Date getApprovedTime() {
        return approvedTime;
    }

    public void setApprovedTime(Date approvedTime) {
        this.approvedTime = approvedTime;
    }
    public Integer getFinishFlag() {
        return finishFlag;
    }

    public void setFinishFlag(Integer finishFlag) {
        this.finishFlag = finishFlag;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Date getChangeApprovedTime() {
        return changeApprovedTime;
    }

    public void setChangeApprovedTime(Date changeApprovedTime) {
        this.changeApprovedTime = changeApprovedTime;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getChangeReason() {
        return changeReason;
    }

    @ReferDeserialTransfer
    public void setChangeReason(Long changeReason) {
        this.changeReason = changeReason;
    }

    public String getChangeDescription() {
        return changeDescription;
    }

    public void setChangeDescription(String changeDescription) {
        this.changeDescription = changeDescription;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getCalendarUid() {
        return calendarUid;
    }

    public void setCalendarUid(String calendarUid) {
        this.calendarUid = calendarUid;
    }
    public String getCalendars() {
        return calendars;
    }

    public void setCalendars(String calendars) {
        this.calendars = calendars;
    }

    public List<YearPlanDetailVO> getProgressDetailList() {
        return progressDetailList;
    }

    public void setProgressDetailList(List<YearPlanDetailVO> progressDetailList) {
        this.progressDetailList = progressDetailList;
    }

    public List<YearPlanDetailVO> getRemovedTasks() {
        return removedTasks;
    }

    public void setRemovedTasks(List<YearPlanDetailVO> removedTasks) {
        this.removedTasks = removedTasks;
    }

    public List<YearPlanDetailVO> getTasks() {
        return tasks;
    }

    public void setTasks(List<YearPlanDetailVO> tasks) {
        this.tasks = tasks;
    }

    public String getChangeStatusName() {
        return changeStatusName;
    }

    public void setChangeStatusName(String changeStatusName) {
        this.changeStatusName = changeStatusName;
    }

    public String getChangeVersionName() {
        return changeVersionName;
    }

    public void setChangeVersionName(String changeVersionName) {
        this.changeVersionName = changeVersionName;
    }

    public List<YearPlanDetailVO> getAllList() {
        return allList;
    }

    public void setAllList(List<YearPlanDetailVO> allList) {
        this.allList = allList;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public BigDecimal getDays() {
        return days;
    }

    public void setDays(BigDecimal days) {
        this.days = days;
    }
}
