package com.ejianc.business.plan.cons;

import java.util.*;

public class PlanCloumCons {
    /**
     * 总计划自定义字段
     */
    public static final List<String> TOTAL_PLAN_CLOUM = Arrays.asList("taskLine", "nodeLevel", "employeeName", "planNum", "unit", "resourceName", "type", "typeUnit", "needNum", "planState", "code", "structCode");
    /**
     * 年计划自定义字段
     */
    public static final List<String> YEAR_PLAN_CLOUM = new ArrayList<>(TOTAL_PLAN_CLOUM);
    /**
     * 月计划自定义字段
     */
    public static final List<String> MONTH_PLAN_CLOUM = new ArrayList<>(TOTAL_PLAN_CLOUM);
    /**
     * 周计划自定义字段
     */
    public static final List<String> WEEK_PLAN_CLOUM = new ArrayList<>(TOTAL_PLAN_CLOUM);
    /**
     * 执行计划自定义字段
     */
    public static final List<String> EXEC_PLAN_CLOUM = new ArrayList<>(TOTAL_PLAN_CLOUM);

    static {
        EXEC_PLAN_CLOUM.addAll(Arrays.asList("percentTask", "planStart", "planFinish", "predictStart", "predictFinish",
                "finishNum", "finishState", "lightType", "diffValue", "sourceId", "sourceBid", "estimateFinish", "diffType",
                "diffResson", "resourceNum", "diffNum"));
    }

    public static final Map<String, CustomizeCloumVO> CUSTOMIZE_CLOMN_MAP = new HashMap();

    static {
        CustomizeCloumVO taskLine = new CustomizeCloumVO();
        taskLine.setField("taskLine");
        taskLine.setFieldName("任务条线");
        taskLine.setFieldID("188743750");// 文本10
        taskLine.setValue(PlanConstant.TASK_LINE);

        CustomizeCloumVO nodeLevel = new CustomizeCloumVO();
        nodeLevel.setField("nodeLevel");
        nodeLevel.setFieldName("节点级别");
        nodeLevel.setFieldID("188743997");// 文本11
        nodeLevel.setValue(PlanConstant.NODE_LEVEL);

        CustomizeCloumVO unit = new CustomizeCloumVO();
        unit.setField("unit");
        unit.setFieldName("单位");
        unit.setFieldID("188743737");// 文本3
        unit.setValue(PlanConstant.UNIT);

        CustomizeCloumVO type = new CustomizeCloumVO();
        type.setField("type");
        type.setFieldName("资源类型_");
        type.setFieldID("188743740");// 文本4
        type.setValue(PlanConstant.RESOURCE_TYPE);

        CustomizeCloumVO typeUnit = new CustomizeCloumVO();
        typeUnit.setField("typeUnit");
        typeUnit.setFieldName("资源单位");
        typeUnit.setFieldID("188743743");//文本5
        typeUnit.setValue(PlanConstant.RESOURCE_UNIT);

        CustomizeCloumVO planNum = new CustomizeCloumVO();
        planNum.setField("planNum");
        planNum.setFieldName("工程量");
        planNum.setFieldID("188743769");// 数字3

        CustomizeCloumVO code = new CustomizeCloumVO();
        code.setField("code");
        code.setFieldName("编码");
        code.setFieldID("188743746");//文本6

        CustomizeCloumVO structCode = new CustomizeCloumVO();
        structCode.setField("structCode");
        structCode.setFieldName("结构码");
        structCode.setFieldID("188743747");//文本7

        CustomizeCloumVO resourceName = new CustomizeCloumVO();
        resourceName.setField("resourceName");
        resourceName.setFieldName("资源名称_");
        resourceName.setFieldID("188743748");// 文本8

        CustomizeCloumVO needNum = new CustomizeCloumVO();
        needNum.setField("needNum");
        needNum.setFieldName("需求量");
        needNum.setFieldID("188743768");// 数字2

        CustomizeCloumVO employeeName = new CustomizeCloumVO();
        employeeName.setField("employeeName");
        employeeName.setFieldName("负责人");
        employeeName.setFieldID("188743998");// 文本12

        CUSTOMIZE_CLOMN_MAP.put("taskLine", taskLine);
        CUSTOMIZE_CLOMN_MAP.put("nodeLevel", nodeLevel);
        CUSTOMIZE_CLOMN_MAP.put("unit", unit);
        CUSTOMIZE_CLOMN_MAP.put("type", type);
        CUSTOMIZE_CLOMN_MAP.put("typeUnit", typeUnit);
        CUSTOMIZE_CLOMN_MAP.put("planNum", planNum);
        CUSTOMIZE_CLOMN_MAP.put("code", code);
        CUSTOMIZE_CLOMN_MAP.put("structCode", structCode);
        CUSTOMIZE_CLOMN_MAP.put("resourceName", resourceName);
        CUSTOMIZE_CLOMN_MAP.put("needNum", needNum);
        CUSTOMIZE_CLOMN_MAP.put("employeeName", employeeName);
    }

    public static final Map<String, CustomizeCloumVO> CUSTOMIZE_EXEC_CLOMN_MAP = new HashMap();

    static {
        CUSTOMIZE_EXEC_CLOMN_MAP.putAll(CUSTOMIZE_CLOMN_MAP);
//        CustomizeCloumVO employeeName = new CustomizeCloumVO();
//        employeeName.setField("employeeName");
//        employeeName.setFieldName("负责人");
//        employeeName.setFieldID("188743998");// 文本12
//
//        CUSTOMIZE_EXEC_CLOMN_MAP.put("employeeName", employeeName);
    }
}
