package com.ejianc.business.plan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.*;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;


/**
 * 总计划详情变更
 *
 * @author generator
 */
public class TotalPlanDetailChangeVO extends BaseDetailVO {
    private static final long serialVersionUID = 1L;

    private Long totalId; // 总计划主键
    private Long totalBid; // 主表主键

    private Integer taskLine; // 任务条线(手续线、设计线、建造线、招采线)
    private Integer nodeLevel; // 节点级别
    private Long employeeId; // 负责人主键
    private String employeeName; // 负责人名称
    private BigDecimal planNum; // 工程量
    private Integer unit; // 单位(枚举格式， 包含：㎡、m、m3、kg、t、个)
    private String resourceName; // 资源名称
    private Integer type; // 资源类型(劳动力、材料、机械)
    private Integer typeUnit; // 资源单位(㎡、m、m3、kg、t、个、台班、工日)
    private BigDecimal needNum; // 需求量
    private Integer changeType; // 变更类型,0-未变更,1-变更项,2-新增项
    private List<TotalPlanDetailChangeVO> children = new ArrayList<>();// 子任务
    private Boolean useState; // 是否日反馈引用
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private Date delayFinish; // 延后完成日期

    public Boolean getUseState() {
        return useState;
    }

    public void setUseState(Boolean useState) {
        this.useState = useState;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public List<TotalPlanDetailChangeVO> getChildren() {
        return children;
    }

    public void setChildren(List<TotalPlanDetailChangeVO> children) {
        this.children = children;
    }

    public Long getTotalId() {
        return totalId;
    }

    public void setTotalId(Long totalId) {
        this.totalId = totalId;
    }

    public Long getTotalBid() {
        return totalBid;
    }

    public void setTotalBid(Long totalBid) {
        this.totalBid = totalBid;
    }

    public Integer getTaskLine() {
        return taskLine;
    }

    public void setTaskLine(Integer taskLine) {
        this.taskLine = taskLine;
    }

    public Integer getNodeLevel() {
        return nodeLevel;
    }

    public void setNodeLevel(Integer nodeLevel) {
        this.nodeLevel = nodeLevel;
    }
    //@ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    //@ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getTypeUnit() {
        return typeUnit;
    }

    public void setTypeUnit(Integer typeUnit) {
        this.typeUnit = typeUnit;
    }

    public BigDecimal getNeedNum() {
        return needNum;
    }

    public void setNeedNum(BigDecimal needNum) {
        this.needNum = needNum;
    }

    public Date getDelayFinish() {
        return delayFinish;
    }

    public void setDelayFinish(Date delayFinish) {
        this.delayFinish = delayFinish;
    }

}
