package com.ejianc.business.probuilddiary.ledger.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 日志台账-工程资料归档及会议情况（资料员）
 *
 * @author baipengyan
 */
public class LedgerInformationVO extends BaseVO {
	private static final long serialVersionUID = -6908564293593954659L;

	private Long personId; // 个人日志id
	private Long informMoldId; // 工作类型id
	private String informMoldName; // 工作类型名称
	private String informMoldCode; // 工作类型编码
	private String informationMemo; // 工作描述
	private Long commitUserId; // 提交人id
	private String commitUserCode; // 提交人账号
	private String commitUserName; // 提交人名称
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date commitDate; // 提交日期
	private Long projectLogId; // 项目日志id
	private Long ledgerId; // 日志台账id
	private String templateContent; // 模版内容，#分隔开的字段名称，例如：commitUserName#commitDate#workMemo，输出：张三 16：00 完成1号楼基础部分基坑支护
	private String fileType; // 文件类型
	private String logNumber; // 日志项编码
	private Boolean projectManagerFlag; // 项目经理标识


	public Long getPersonId() {
		return personId;
	}

	public void setPersonId(Long personId) {
		this.personId = personId;
	}

	public Long getInformMoldId() {
		return informMoldId;
	}

	public void setInformMoldId(Long informMoldId) {
		this.informMoldId = informMoldId;
	}

	public String getInformMoldName() {
		return informMoldName;
	}

	public void setInformMoldName(String informMoldName) {
		this.informMoldName = informMoldName;
	}

	public String getInformMoldCode() {
		return informMoldCode;
	}

	public void setInformMoldCode(String informMoldCode) {
		this.informMoldCode = informMoldCode;
	}

	public String getInformationMemo() {
		return informationMemo;
	}

	public void setInformationMemo(String informationMemo) {
		this.informationMemo = informationMemo;
	}

	public Long getCommitUserId() {
		return commitUserId;
	}

	public void setCommitUserId(Long commitUserId) {
		this.commitUserId = commitUserId;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public Long getProjectLogId() {
		return projectLogId;
	}

	public void setProjectLogId(Long projectLogId) {
		this.projectLogId = projectLogId;
	}

	public Long getLedgerId() {
		return ledgerId;
	}

	public void setLedgerId(Long ledgerId) {
		this.ledgerId = ledgerId;
	}

	public String getTemplateContent() {
		return templateContent;
	}

	public void setTemplateContent(String templateContent) {
		this.templateContent = templateContent;
	}

	public String getFileType() {
		return fileType;
	}

	public void setFileType(String fileType) {
		this.fileType = fileType;
	}

	public String getLogNumber() {
		return logNumber;
	}

	public void setLogNumber(String logNumber) {
		this.logNumber = logNumber;
	}

	public Boolean getProjectManagerFlag() {
		return projectManagerFlag;
	}

	public void setProjectManagerFlag(Boolean projectManagerFlag) {
		this.projectManagerFlag = projectManagerFlag;
	}
}
