package com.ejianc.business.fill.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.plan.vo.BaseDetailVO;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 日进度计划填报详情
 *
 * @author generator
 */
public class DayFillDetailVO extends BaseDetailVO {
    private static final long serialVersionUID = 1L;


    private Integer taskLine; // 任务条线(手续线、设计线、建造线、招采线)
    private Integer nodeLevel; // 节点级别
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private Date planStart; // 计划开始日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private Date planFinish; // 计划完成日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private Date estimateFinish; // 预计完成日期
    private Long employeeId; // 负责人主键
    private String employeeName; // 负责人名称
    private BigDecimal planNum; // 工程量
    private BigDecimal finishNum; // 完成工程量
    private Integer unit; // 单位(枚举格式， 包含：㎡、m、m3、kg、t、个)
    private BigDecimal diffValue; // 偏差时间
    private Long diffType; // 偏差原因类型
    private String diffResson; // 偏差原因
    private String resourceName; // 资源名称
    private Integer type; // 资源类型(劳动力、材料、机械)
    private Integer typeUnit; // 资源单位(㎡、m、m3、kg、t、个、台班、工日)
    private BigDecimal needNum; // 需求量
    private BigDecimal resourceNum; // 实际资源量
    private BigDecimal diffNum; // 资源偏差
    private Integer startSourceType;
    private Boolean leafFlag; // 是否末级(0-否，1-是)
    private Integer planDuration;// 计划工期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private Date predictStart; // 预测开始日期
    private Boolean showState; // 显隐标识 0-隐藏 1-显示
    private String planPreLink;// 计划前置任务
    private String parentName;
    private Integer finishState;
    private String diffTypeName;
    private Integer thisPercentComplete; // 本期完成百分比
    private BigDecimal thisPlanNum; // 本期计划工程量
    private BigDecimal thisFinishNum; // 本期完成工程量
    private BigDecimal nextPlanNum; // 下期计划工程量
    private BigDecimal lastFinishNum; // 截止上期完成工程量

    private List<DayFillDetailVO> children = new ArrayList<>();// 子任务

    public String getDiffTypeName() {
        return diffTypeName;
    }

    public void setDiffTypeName(String diffTypeName) {
        this.diffTypeName = diffTypeName;
    }

    public Integer getFinishState() {
        return finishState;
    }

    public void setFinishState(Integer finishState) {
        this.finishState = finishState;
    }

    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public Integer getStartSourceType() {
        return startSourceType;
    }

    public void setStartSourceType(Integer startSourceType) {
        this.startSourceType = startSourceType;
    }

    public List<DayFillDetailVO> getChildren() {
        return children;
    }

    public void setChildren(List<DayFillDetailVO> children) {
        this.children = children;
    }

    public Integer getTaskLine() {
        return taskLine;
    }

    public void setTaskLine(Integer taskLine) {
        this.taskLine = taskLine;
    }

    public Integer getNodeLevel() {
        return nodeLevel;
    }

    public void setNodeLevel(Integer nodeLevel) {
        this.nodeLevel = nodeLevel;
    }

    public Date getPlanStart() {
        return planStart;
    }

    public void setPlanStart(Date planStart) {
        this.planStart = planStart;
    }

    public Date getPlanFinish() {
        return planFinish;
    }

    public void setPlanFinish(Date planFinish) {
        this.planFinish = planFinish;
    }

    public Date getEstimateFinish() {
        return estimateFinish;
    }

    public void setEstimateFinish(Date estimateFinish) {
        this.estimateFinish = estimateFinish;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public BigDecimal getFinishNum() {
        return finishNum;
    }

    public void setFinishNum(BigDecimal finishNum) {
        this.finishNum = finishNum;
    }

    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    public BigDecimal getDiffValue() {
        return diffValue;
    }

    public void setDiffValue(BigDecimal diffValue) {
        this.diffValue = diffValue;
    }

    public Long getDiffType() {
        return diffType;
    }

    public void setDiffType(Long diffType) {
        this.diffType = diffType;
    }

    public String getDiffResson() {
        return diffResson;
    }

    public void setDiffResson(String diffResson) {
        this.diffResson = diffResson;
    }

    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getTypeUnit() {
        return typeUnit;
    }

    public void setTypeUnit(Integer typeUnit) {
        this.typeUnit = typeUnit;
    }

    public BigDecimal getNeedNum() {
        return needNum;
    }

    public void setNeedNum(BigDecimal needNum) {
        this.needNum = needNum;
    }

    public BigDecimal getResourceNum() {
        return resourceNum;
    }

    public void setResourceNum(BigDecimal resourceNum) {
        this.resourceNum = resourceNum;
    }

    public BigDecimal getDiffNum() {
        return diffNum;
    }

    public void setDiffNum(BigDecimal diffNum) {
        this.diffNum = diffNum;
    }

    public Integer getPlanDuration() {
        return planDuration;
    }

    public void setPlanDuration(Integer planDuration) {
        this.planDuration = planDuration;
    }
    public Date getPredictStart() {
        return predictStart;
    }

    public void setPredictStart(Date predictStart) {
        this.predictStart = predictStart;
    }

    public Boolean getShowState() {
        return showState;
    }

    public void setShowState(Boolean showState) {
        this.showState = showState;
    }

    public String getPlanPreLink() {
        return planPreLink;
    }

    public void setPlanPreLink(String planPreLink) {
        this.planPreLink = planPreLink;
    }

    public Integer getThisPercentComplete() {
        return thisPercentComplete;
    }

    public void setThisPercentComplete(Integer thisPercentComplete) {
        this.thisPercentComplete = thisPercentComplete;
    }

    public BigDecimal getThisPlanNum() {
        return thisPlanNum;
    }

    public void setThisPlanNum(BigDecimal thisPlanNum) {
        this.thisPlanNum = thisPlanNum;
    }

    public BigDecimal getThisFinishNum() {
        return thisFinishNum;
    }

    public void setThisFinishNum(BigDecimal thisFinishNum) {
        this.thisFinishNum = thisFinishNum;
    }

    public BigDecimal getNextPlanNum() {
        return nextPlanNum;
    }

    public void setNextPlanNum(BigDecimal nextPlanNum) {
        this.nextPlanNum = nextPlanNum;
    }

    public BigDecimal getLastFinishNum() {
        return lastFinishNum;
    }

    public void setLastFinishNum(BigDecimal lastFinishNum) {
        this.lastFinishNum = lastFinishNum;
    }
}
