package com.ejianc.business.fill.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;


/**
 * 项目亮灯关联实体
 * 
 * @author generator
 * 
 */
public class ProjectLightVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long projectId; // 项目
    private String projectCode; // 项目编号
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long corpId; // 所属组织
    private String corpName; // 所属组织名称
    private Long execPlanId; // 执行计划主键
    private String execPlanName; // 执行计划名称
    private String execPlanCode; // 执行计划名称
    private Long projectDepartmentId;//项目部主键
    private Long projectCategory; // 项目类别
    private String projectCategoryName; // 项目类别名称
    private String mobilePhone;// 联系电话
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 竣工日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date actualEndDate; // 实际竣工日期

    private Integer lightType; // 亮灯,0-绿，1-黄，2-红
    private Long projectManager; // 项目经理
    private String projectManagerName; // 项目经理名称
    private Long projectType; // 项目类型
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 开工日期
    private Integer criticalPath; // 关键路径是否延误(1-是，0-否)
    private BigDecimal diffValue; // 偏差值
    private BigDecimal sumWarn; // 累计报警次数
    private String connectState; // 是否关联进度 未关联，已关联

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date minPredictStart; //最小预测开始时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date maxPredictFinish; //最大预测完成时间

    private Long projectControlLevel; // 项目管控级别

    private List<ProjectTrendVO> projectTrendList; //项目偏差趋势

    private Long contractualModel; // 项目类型(承包模式)
    private String builtArea;// 建筑面积
    private BigDecimal selfConstructionContractAmount; // 自施合同额(元)
    private Integer duration; // 工期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date actualStartDate; // 实际开工日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planEndDate; // 计划竣工日期
    private Integer signDays; // 工期签证天数
    private Integer waitDays; // 待批工期签证
    private String imageShows; // 形象进度
    private String reason; // 原因分析
    private String measure; // 拟采取措施
    private Integer diffDays; // 实际滞后天数
    private Integer planDays; // 预计滞后天数
    private BigDecimal performanceRate; // 项目合同工期履约率

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getContractualModel() {
        return contractualModel;
    }

    @ReferDeserialTransfer
    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }

    public String getBuiltArea() {
        return builtArea;
    }

    public void setBuiltArea(String builtArea) {
        this.builtArea = builtArea;
    }

    public BigDecimal getSelfConstructionContractAmount() {
        return selfConstructionContractAmount;
    }

    public void setSelfConstructionContractAmount(BigDecimal selfConstructionContractAmount) {
        this.selfConstructionContractAmount = selfConstructionContractAmount;
    }

    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Date getActualStartDate() {
        return actualStartDate;
    }

    public void setActualStartDate(Date actualStartDate) {
        this.actualStartDate = actualStartDate;
    }

    public Date getPlanEndDate() {
        return planEndDate;
    }

    public void setPlanEndDate(Date planEndDate) {
        this.planEndDate = planEndDate;
    }

    public Integer getSignDays() {
        return signDays;
    }

    public void setSignDays(Integer signDays) {
        this.signDays = signDays;
    }

    public Integer getWaitDays() {
        return waitDays;
    }

    public void setWaitDays(Integer waitDays) {
        this.waitDays = waitDays;
    }

    public String getImageShows() {
        return imageShows;
    }

    public void setImageShows(String imageShows) {
        this.imageShows = imageShows;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getMeasure() {
        return measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }

    public Integer getDiffDays() {
        return diffDays;
    }

    public void setDiffDays(Integer diffDays) {
        this.diffDays = diffDays;
    }

    public Integer getPlanDays() {
        return planDays;
    }

    public void setPlanDays(Integer planDays) {
        this.planDays = planDays;
    }

    public BigDecimal getPerformanceRate() {
        return performanceRate;
    }

    public void setPerformanceRate(BigDecimal performanceRate) {
        this.performanceRate = performanceRate;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }

    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }

    public Long getExecPlanId() {
        return execPlanId;
    }

    public void setExecPlanId(Long execPlanId) {
        this.execPlanId = execPlanId;
    }

    public String getExecPlanName() {
        return execPlanName;
    }

    public void setExecPlanName(String execPlanName) {
        this.execPlanName = execPlanName;
    }

    public String getExecPlanCode() {
        return execPlanCode;
    }

    public void setExecPlanCode(String execPlanCode) {
        this.execPlanCode = execPlanCode;
    }

    public Integer getLightType() {
        return lightType;
    }

    public void setLightType(Integer lightType) {
        this.lightType = lightType;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    public BigDecimal getDiffValue() {
        return diffValue;
    }

    public void setDiffValue(BigDecimal diffValue) {
        this.diffValue = diffValue;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getProjectControlLevel() {
        return projectControlLevel;
    }
    @ReferDeserialTransfer
    public void setProjectControlLevel(Long projectControlLevel) {
        this.projectControlLevel = projectControlLevel;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectManager() {
        return projectManager;
    }
    @ReferDeserialTransfer
    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }

    public Long getProjectType() {
        return projectType;
    }

    public void setProjectType(Long projectType) {
        this.projectType = projectType;
    }

    public Integer getCriticalPath() {
        return criticalPath;
    }

    public void setCriticalPath(Integer criticalPath) {
        this.criticalPath = criticalPath;
    }

    public BigDecimal getSumWarn() {
        return sumWarn;
    }

    public void setSumWarn(BigDecimal sumWarn) {
        this.sumWarn = sumWarn;
    }

    public String getConnectState() {
        return connectState;
    }

    public void setConnectState(String connectState) {
        this.connectState = connectState;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getProjectCategory() {
        return projectCategory;
    }
    @ReferDeserialTransfer
    public void setProjectCategory(Long projectCategory) {
        this.projectCategory = projectCategory;
    }

    public String getProjectCategoryName() {
        return projectCategoryName;
    }

    public void setProjectCategoryName(String projectCategoryName) {
        this.projectCategoryName = projectCategoryName;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getActualEndDate() {
        return actualEndDate;
    }

    public void setActualEndDate(Date actualEndDate) {
        this.actualEndDate = actualEndDate;
    }

    public String getMobilePhone() {
        return mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public List<ProjectTrendVO> getProjectTrendList() {
        return projectTrendList;
    }

    public void setProjectTrendList(List<ProjectTrendVO> projectTrendList) {
        this.projectTrendList = projectTrendList;
    }

    public Date getMinPredictStart() {
        return minPredictStart;
    }

    public void setMinPredictStart(Date minPredictStart) {
        this.minPredictStart = minPredictStart;
    }

    public Date getMaxPredictFinish() {
        return maxPredictFinish;
    }

    public void setMaxPredictFinish(Date maxPredictFinish) {
        this.maxPredictFinish = maxPredictFinish;
    }
}
