package com.ejianc.business.plan.vo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 年计划详情
 * 
 * @author generator
 * 
 */
public class YearPlanDetailVO extends BaseDetailVO {
    private static final long serialVersionUID = 1L;


    private Integer taskLine; // 任务条线(手续线、设计线、建造线、招采线)
    private Integer nodeLevel; // 节点级别
    private Long employeeId; // 负责人主键
    private String employeeName; // 负责人名称
    private BigDecimal planNum; // 工程量
    private Integer unit; // 单位(枚举格式， 包含：㎡、m、m3、kg、t、个)
    private String resourceName; // 资源名称
    private Integer type; // 资源类型(劳动力、材料、机械)
    private Integer typeUnit; // 资源单位(㎡、m、m3、kg、t、个、台班、工日)
    private BigDecimal needNum; // 需求量
    private Integer planState; // 任务标识
    private Long sourceBid; // 执行计划明细主键
    private Long sourceId; // 执行计划单据主键

    private List<YearPlanDetailVO> children = new ArrayList<>();// 子任务


    public Integer getTaskLine() {
        return taskLine;
    }

    public void setTaskLine(Integer taskLine) {
        this.taskLine = taskLine;
    }
    public Integer getNodeLevel() {
        return nodeLevel;
    }

    public void setNodeLevel(Integer nodeLevel) {
        this.nodeLevel = nodeLevel;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }
    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }
    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
    public Integer getTypeUnit() {
        return typeUnit;
    }

    public void setTypeUnit(Integer typeUnit) {
        this.typeUnit = typeUnit;
    }
    public BigDecimal getNeedNum() {
        return needNum;
    }

    public void setNeedNum(BigDecimal needNum) {
        this.needNum = needNum;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getSourceBid() {
        return sourceBid;
    }

    public void setSourceBid(Long sourceBid) {
        this.sourceBid = sourceBid;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getPlanState() {
        return planState;
    }

    public void setPlanState(Integer planState) {
        this.planState = planState;
    }

    public List<YearPlanDetailVO> getChildren() {
        return children;
    }

    public void setChildren(List<YearPlanDetailVO> children) {
        this.children = children;
    }



    public static YearPlanDetailVO convertVoExecVOToYearVO(ExecPlanDetailVO vo){
        YearPlanDetailVO progressDetailVO = new YearPlanDetailVO();

        progressDetailVO.setUid(vo.getUid());
        progressDetailVO.setManual(vo.getManual());
        progressDetailVO.setActualDuration(vo.getActualDuration());
        progressDetailVO.setDuration(vo.getDuration());
        progressDetailVO.setPercentComplete(vo.getPercentComplete());
        progressDetailVO.setDepartment(vo.getDepartment());
        progressDetailVO.setProjectUID(vo.getProjectUID());
        progressDetailVO.setMilestone(vo.getMilestone());
        progressDetailVO.setFinish(vo.getFinish());
        progressDetailVO.setConstraintType(vo.getConstraintType());
        progressDetailVO.setPrincipal(vo.getPrincipal());
        progressDetailVO.setParentTaskUID(vo.getParentTaskUID());
        progressDetailVO.setWbs(vo.getWbs());
        if(vo.getAssignments() != null && vo.getAssignments().size() > 0) {
            progressDetailVO.setAssignments(vo.getAssignments());
        }
        progressDetailVO.setStart(vo.getStart());
        progressDetailVO.setOutlineLevel(vo.getOutlineLevel());
        progressDetailVO.setOutlineNumber(vo.getOutlineNumber());
        progressDetailVO.setCritical(vo.getCritical());
        progressDetailVO.setNote(vo.getNote());
        progressDetailVO.setSummary(vo.getSummary());
        progressDetailVO.setActualFinish(vo.getActualFinish());
        progressDetailVO.setName(vo.getName());
        progressDetailVO.setId(vo.getId());
        progressDetailVO.setWeight(vo.getWeight());
        progressDetailVO.setFixedDate(vo.getFixedDate());
        progressDetailVO.setWork(vo.getWork());
        progressDetailVO.setConstraintDate(vo.getConstraintDate());
        if(vo.getPredecessorLink() != null && vo.getPredecessorLink().size() > 0) {
            progressDetailVO.setPredecessorLink(vo.getPredecessorLink());
        }
        progressDetailVO.setPriority(vo.getPriority());
        progressDetailVO.setActualStart(vo.getActualStart());

        progressDetailVO.setTaskLine(vo.getTaskLine()); // 任务条线(手续线、设计线、建造线、招采线)
        progressDetailVO.setNodeLevel(vo.getNodeLevel()); // 节点级别
        progressDetailVO.setEmployeeId(vo.getEmployeeId()); // 负责人主键
        progressDetailVO.setEmployeeName(vo.getEmployeeName()); // 负责人名称
        progressDetailVO.setPlanNum(vo.getPlanNum()); // 工程量
        progressDetailVO.setUnit(vo.getUnit()); // 单位(枚举格式， 包含：㎡、m、m3、kg、t、个)
        progressDetailVO.setResourceName(vo.getResourceName()); // 资源名称
        progressDetailVO.setType(vo.getType()); // 资源类型(劳动力、材料、机械)
        progressDetailVO.setTypeUnit(vo.getTypeUnit()); // 资源单位(㎡、m、m3、kg、t、个、台班、工日)
        progressDetailVO.setNeedNum(vo.getNeedNum()); // 需求量
        progressDetailVO.setPlanState(vo.getPlanState()); //任务标识

        return progressDetailVO;
    }


}
