package com.ejianc.business.probuilddiary.construct.vo;

import com.ejianc.business.probuilddiary.construct.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 施工区域导入
 *
 * @author CJ
 * @Description:
 * @date 2022/9/23 15:44
 */
public class ConstructAreaImportVO extends BaseVO implements ITreeNodeB {

    private static final long serialVersionUID = 211862307147246400L;

    /**
     * 序号
     */
    private String treeIndex;
    /**
     * 施工区域
     */
    private String constructionRegion;
    /**
     * 错误信息
     */
    private String errorMsg;

    /**
     * 本级Id
     */
    private String tid;
    /**
     * 父Id
     */
    private String tpid;

    /**
     * 父ID
     */
    private Long parentId;

    /**
     * 清单ID
     */
    private Long detailId;
    private List<ITreeNodeB> children;
    private String detailStatus; // 状态 0停用 1 启用

    public String getDetailStatus() {
        return detailStatus;
    }

    public void setDetailStatus(String detailStatus) {
        this.detailStatus = detailStatus;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public String getConstructionRegion() {
        return constructionRegion;
    }

    public void setConstructionRegion(String constructionRegion) {
        this.constructionRegion = constructionRegion;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getDetailId() {
        return detailId;
    }

    public void setDetailId(Long detailId) {
        this.detailId = detailId;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }
}
