package com.ejianc.business.progress.vo;

import java.util.List;
import java.util.ArrayList;

import com.ejianc.business.progress.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 节点档案
 * 
 * @author generator
 * 
 */
public class DocVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;
    
    private Long nodeArchivesId; // 节点档案分类主键
    private String detailIndex; // 树形编码
    private String code; // 节点编码
    private String structCode; // 结构码，由所有父级本机编码构成
    private String name; // 节点名称
    private Integer nodeType; // 节点标识(0-非关键节点，1-关键节点)
    private String nodeTypeName; // 节点标识名称
    private String unit; // 单位
    private Integer nodeLevel; // 节点级次(1-1级。。)当前是第几级节点
    private Boolean leafFlag; // 是否末级(0-否，1-是)
    private Long parentId; // 空间父ID
    private String innerCode; // 空间内码

    private String tid;
    private String tpid;
    private Integer excelIndex;// 在excel中是第几行数据
    private String begin;// 在excel中起始日期
    private String end;// 在excel中结束日期
    private String planNumString;// 在excel计划完成量
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    //错误信息
    private String warnType;
    private String shadowId;


    private List<ITreeNodeB> children;
    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    /**
     * 节点档案分类主键
     */
    public Long getNodeArchivesId() {
        return nodeArchivesId;
    }

    /**
     * 节点档案分类主键
     */
    public void setNodeArchivesId(Long nodeArchivesId) {
        this.nodeArchivesId = nodeArchivesId;
    }

    /**
     * 树形编码
     */
    public String getDetailIndex() {
        return detailIndex;
    }

    /**
     * 树形编码
     */
    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    /**
     * 节点编码
     */
    public String getCode() {
        return code;
    }

    /**
     * 节点编码
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 结构码，由所有父级本机编码构成
     */
    public String getStructCode() {
        return structCode;
    }

    /**
     * 结构码，由所有父级本机编码构成
     */
    public void setStructCode(String structCode) {
        this.structCode = structCode;
    }
    /**
     * 节点名称
     */
    public String getName() {
        return name;
    }

    /**
     * 节点名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 节点标识(0-非关键节点，1-关键节点)
     */
    public Integer getNodeType() {
        return nodeType;
    }

    /**
     * 节点标识(0-非关键节点，1-关键节点)
     */
    public void setNodeType(Integer nodeType) {
        this.nodeType = nodeType;
    }

    public String getNodeTypeName() {
        return nodeTypeName;
    }

    public void setNodeTypeName(String nodeTypeName) {
        this.nodeTypeName = nodeTypeName;
    }

    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }

    /**
     * 节点级次(1-1级。。)当前是第几级节点
     */
    public Integer getNodeLevel() {
        return nodeLevel;
    }

    /**
     * 节点级次(1-1级。。)当前是第几级节点
     */
    public void setNodeLevel(Integer nodeLevel) {
        this.nodeLevel = nodeLevel;
    }
    /**
     * 是否末级(0-否，1-是)
     */
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    /**
     * 是否末级(0-否，1-是)
     */
    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
    /**
     * 空间父ID
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * 空间父ID
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 空间内码
     */
    public String getInnerCode() {
        return innerCode;
    }

    /**
     * 空间内码
     */
    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public Integer getExcelIndex() {
        return excelIndex;
    }

    public void setExcelIndex(Integer excelIndex) {
        this.excelIndex = excelIndex;
    }

    public String getBegin() {
        return begin;
    }

    public void setBegin(String begin) {
        this.begin = begin;
    }

    public String getEnd() {
        return end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public String getPlanNumString() {
        return planNumString;
    }

    public void setPlanNumString(String planNumString) {
        this.planNumString = planNumString;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public String getShadowId() {
        return shadowId;
    }

    public void setShadowId(String shadowId) {
        this.shadowId = shadowId;
    }
}
