package com.ejianc.business.bim.helper;

import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @description 模拟本地缓存
 * 
 * 		<p>
 * 		只作为示例，未添加缓存失效以及缓存淘汰机制，实际使用中，可使用redis缓存，如果是非分布式缓存架构，可使用guava的loadingCache来代替
 * 
 * @author 宫清
 * @date 2019年7月20日 下午3:52:41
 * @since JDK1.7
 */
@Component
public class CacheHelper {

	private static final Map<String, Object> localCache = Maps.newConcurrentMap();

	// 工程名称
	@Value("${spring.application.name}")
	private String ApplicationName;

	public static String APPLICATION_NAME;

	/**
	 *  不允许外部创建实例
	 */
	private CacheHelper() {
	}

	//静态初始化当前类
	private static CacheHelper helper;

	//在方法上加上注解@PostConstruct,这样方法就会在bean初始化之后被spring容器执行
	@PostConstruct
	public void init(){
		//声明的静态类=this
		helper = this;
		APPLICATION_NAME = ApplicationName;
	}

	/**
	 * @description 添加元素
	 *
	 * @param k
	 * @param v
	 * @author 宫清
	 * @date 2019年7月20日 下午3:52:56
	 */
	public static void put(String k, Object v) {
		if(APPLICATION_NAME != null){
			String cacheKey = APPLICATION_NAME + ":" + k;
			RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("redisTemplate", RedisTemplate.class);
			redisTemplate.opsForValue().set(cacheKey, v, 5, TimeUnit.DAYS);
		} else {
			localCache.put(k, v);
		}
	}

	/**
	 * @description 获取元素
	 *
	 * @param k
	 * @return
	 * @author 宫清
	 * @date 2019年7月20日 下午3:53:04
	 */
	public static Object get(String k) {
		if(APPLICATION_NAME != null){
			String cacheKey = APPLICATION_NAME + ":" + k;
			RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("redisTemplate", RedisTemplate.class);
			Object cacheValue = redisTemplate.opsForValue().get(cacheKey);
			return cacheValue;
		} else {
			return localCache.get(k);
		}
	}
	
	/**
	 * @description 移除元素
	 *
	 * @param k
	 * @author 宫清
	 * @date 2019年7月20日 下午3:55:54
	 */
	public static void remove(String k) {
		if(APPLICATION_NAME != null){
			String cacheKey = APPLICATION_NAME + ":" + k;
			RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("redisTemplate", RedisTemplate.class);
			redisTemplate.delete(cacheKey);
		} else {
			localCache.remove(k);
		}
	}
	

}
