package com.ejianc.business.bim.helper;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description 鉴权认证 辅助类
 * @author 宫清
 * @date 2019年7月19日 上午11:54:28
 * @since JDK1.7
 */
@Component
public class TokenHelper {

	private static Logger logger = LoggerFactory.getLogger(TokenHelper.class);

//	public static final String BASE_HOST = "https://sales.dxbim.com:8443";
//	public static final String BASE_HOST = "https://bm.ccstc-online.com";
	public static final String BASE_HOST = "https://xbase.ccstc-online.com:4433";

//	private static final String APP_ID = "9204360f0a8a4bb8a5d523401f2872cb";
	private static final String APP_ID = "38ca8eb61b94d568577bba58902ce2e4";

//	private static final String SECURITY_KEY = "c3c48e5a92b74dbf862b77b348511978";
    private static final String SECURITY_KEY = "a19b1b8b1ab43353bf29a4e241e1add5";

	/*
	 * token 缓存 key
	 */
	public static final String TOKEN = "TOKEN";

	public static final String VIEWER_TOKEN = "VIEWER_TOKEN";

	/**
	 * 不允许外部创建实例
	 */
	private TokenHelper() {
	}

	//静态初始化当前类
	private static TokenHelper helper;

	//在方法上加上注解@PostConstruct,这样方法就会在bean初始化之后被spring容器执行
	@PostConstruct
	public void init(){
		//声明的静态类=this
		helper = this;
		if(logger == null){
			logger = LoggerFactory.getLogger(TokenHelper.class);
		}
	}

	// -------------------------------------------公有方法start-------------------------------------------------------

	/**
	 * @description 获取token
	 * 
	 *              实际使用中，可获取token后，放在redis缓存中，如果是非分布式架构，也可使用guava的LoadingCache或者自己构建本地缓存来存储该token，
	 *              缓存存储时，需要注意缓存失效截止时间expiresIn
	 * 
	 * @date 2019年7月19日 上午11:55:57
	 * @author 宫清
	 * @throws BusinessException
	 */
	public static JSONObject getTokenData() throws BusinessException {
		Map<String, String> params = new HashMap<>();
//		params.put("appId", APP_ID);
//		params.put("securityKey", SECURITY_KEY);
		params.put("app_id", APP_ID);
		params.put("app_key", SECURITY_KEY);
		JSONObject json = null;
		try {
//			String response = HttpTookit.postParameters(BASE_HOST + "/api/v3/auth/apptokens", params);
			String response = HttpTookit.postByJson(BASE_HOST + "/api/xbase/v1/app/token", JSONObject.toJSONString(params));
			json = JSONObject.parseObject(response);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		json = JSONHelper.castDataJson(json, JSONObject.class);
		// 模拟存放本地缓存
		toLocalCache(json);
		return json;
	}

	// -------------------------------------------公有方法end---------------------------------------------------------

	// -------------------------------------------私有方法start-------------------------------------------------------

	public static JSONObject getViewerToken(String fileId) throws BusinessException {
		Map<String, String> params = new HashMap<>();
		params.put("app_id", APP_ID);
		params.put("app_key", SECURITY_KEY);
		params.put("file_id", fileId);
		params.put("viewer_type", "model");
		JSONObject json = null;
		try {
			String response = HttpTookit.postByJson(BASE_HOST + "/api/xbase/v1/viewer/token", JSONObject.toJSONString(params));
			json = JSONObject.parseObject(response);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		json = JSONHelper.castDataJson(json, JSONObject.class);
		if(json == null || !json.containsKey("token")){
			return json;
		}
		CacheHelper.put( VIEWER_TOKEN + ":" + fileId, "Bear " + json.getString("token"));
		return json;
	}


	/**
	 * @description 模拟存放本地缓存
	 *
	 * @param json
	 * @author 宫清
	 * @date 2019年7月20日 下午4:04:08
	 */
	private static void toLocalCache(JSONObject json) {
		CacheHelper.put(TOKEN, "Bear " + json.getString("token"));
	}

	public static JSONObject getFileStatus(String path) throws BusinessException {
//		String url = BASE_HOST + "/api/v3/srv/fs/file/status";
//		String url = BASE_HOST + "/fs/dx/api/f/v1/file/status";
		String url = BASE_HOST + "/api/xbase/v1/model/fs/status";
		Map<String, String> headers = new HashMap<>();
		headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
		Map<String, String> params = new HashMap<>();
//		params.put("token", String.valueOf(CacheHelper.get(TOKEN)));
		params.put("path", path);
		JSONObject json = null;
		try {
//			String response = HttpTookit.getAndHeader(url, params);
			String response = HttpTookit.get(url, params, headers);
			json = JSONObject.parseObject(response);
			if(json.getInteger("code").equals(new Integer("10010001"))){
				getTokenData();
//				params.put("token", String.valueOf(CacheHelper.get(TOKEN)));
//				response = HttpTookit.getAndHeader(url, params);
				headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
				response = HttpTookit.get(url, params, headers);
				json = JSONObject.parseObject(response);
			}
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		return JSONHelper.castDataJson(json, JSONObject.class);
	}

	public static JSONObject getTokenExpiry(String token) throws BusinessException {
		String url = BASE_HOST + "/api/xbase/v1/token/expiry";
		Map<String, String> headers = new HashMap<>();
		headers.put("Authorization", token);
		JSONObject json = null;
		try {
			String response = HttpTookit.postFormByJson(url, null, headers);
			json = JSONObject.parseObject(response);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		logger.info("返回大象云查询结果：{}", json);
		return json;
	}

	public static JSONObject getViewerStatus(String path, String viewerToken) throws BusinessException {
		String url = BASE_HOST + "/viewer/model/status";
		Map<String, String> params = new HashMap<>();
		params.put("path", path);
		Map<String, String> headers = new HashMap<>();
		headers.put("Authorization", viewerToken);
		JSONObject json = null;
		try {
			String response = HttpTookit.get(url, params, headers);
			response = JSONHelper.toJsonString(response);
			json = JSONObject.parseObject(response);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		logger.info("返回大象云查询结果：{}", json);
		return json;
	}

	public static JSONObject delFile(String path) throws BusinessException {
//		String url = BASE_HOST + "/api/v3/srv/fs/file";
		String url = BASE_HOST + "/fs/dx/api/f/v1/file?path=" + path;
		Map<String, String> params = new HashMap<>();
//		params.put("token", String.valueOf(CacheHelper.get(TOKEN)));
		params.put("path", path);
		JSONObject json = null;
		try {
			String response = HttpDelTookit.deleteByJson(url, params);
			json = JSONObject.parseObject(response);
//			if(json.getIntValue("code") == 0 && json.get("data") == null){
//				getTokenData();
//				params.put("token", String.valueOf(CacheHelper.get(TOKEN)));
//				response = HttpDelTookit.deleteByJson(url, params);
//				json = JSONObject.parseObject(response);
//			}
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
//		return JSONHelper.castDataJson(json,JSONObject.class);
		return json;
	}

	public static JSONObject delFileBatch(String[] ids) throws BusinessException {
		String url = BASE_HOST + "/api/xbase/v1/model/batch";
		Map<String, String> headers = new HashMap<>();
		headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
		Map<String, Object> params = new HashMap<>();
		params.put("app_id", APP_ID);
		params.put("ids", ids);
		params.put("is_sure", true);
		JSONObject json = null;
		try {
			String response = HttpDelTookit.deleteByJson(url, params, headers);
			json = JSONObject.parseObject(response);
			if(json.getInteger("code").equals(new Integer("10010001"))){
				getTokenData();
				headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
				response = HttpDelTookit.deleteByJson(url, params, headers);
				json = JSONObject.parseObject(response);
			}
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
//		return JSONHelper.castDataJson(json,JSONObject.class);
		logger.info("返回大象云查询结果：{}", json);
		return json;
	}

	public static JSONObject getFileTree(String path) throws BusinessException{
		return getFileTree(path, "tree");
	}

	public static JSONObject getFileTree(String path, String format) throws BusinessException {
//		String url = BASE_HOST + "/fs/dx/api/f/v1/file/tree";
//		String url = BASE_HOST + "/api/v3/srv/fs/file/tree";
		String url = BASE_HOST + "/api/xbase/v1/model/fs/property/tree";
		Map<String, String> headers = new HashMap<>();
		headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
		Map<String, String> params = new HashMap<>();
//		params.put("token", String.valueOf(CacheHelper.get(TOKEN)));
		params.put("path", path);
//		params.put("format", format);
		JSONObject json = null;
		try {
//			String response = HttpTookit.getAndHeader(url, params);
			String response = HttpTookit.get(url, params, headers);
			json = JSONObject.parseObject(response);
			if(json.getInteger("code").equals(new Integer("10010001"))){
				getTokenData();
//				params.put("token", String.valueOf(CacheHelper.get(TOKEN)));
//				response = HttpTookit.getAndHeader(url, params);
				headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
				response = HttpTookit.get(url, params, headers);
				json = JSONObject.parseObject(response);
			}
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		return JSONHelper.castDataJson(json, JSONObject.class);
//		return json;
	}

//	public static JSONObject getFile(String path) throws BusinessException {
//		String url = BASE_HOST + "/fs/dx/api/f/v1/file";
//		Map<String, String> params = new HashMap<>();
//		params.put("path", path);
//		JSONObject json = null;
//		try {
//			String response = HttpTookit.getAndHeader(url, params);
//			json = JSONObject.parseObject(response);
//		} catch (Exception e) {
//			logger.error(e.getMessage());
//		}
//		return json;
//	}

	public static JSONObject getFile(String fileId, String path) throws BusinessException {
		String url = BASE_HOST + "/viewer/model";
		Map<String, String> headers = new HashMap<>();
		String key = TokenHelper.VIEWER_TOKEN + ":" + fileId;
		headers.put("Authorization", String.valueOf(CacheHelper.get(key)));
		headers.put("extension", ".asm");
		headers.put("Content-Type", "text/plain; charset=utf-8");
		headers.put("maxFileSize", "-1");
		headers.put("maxFileSizeMob", "-1");
		headers.put("maxTriangleCount", "-1");
		headers.put("maxTriangleCountMobile", "-1");

		Map<String, Object> params = new HashMap<>();
		params.put("path", path);
		JSONObject json = null;
		try {
			String response = HttpTookit.get(url, params, headers);
			response = JSONHelper.toJsonString(response);
			json = JSONObject.parseObject(response);
			if(json.getInteger("code").equals(new Integer("10000010"))){
				getViewerToken(fileId);
				headers.put("Authorization", String.valueOf(CacheHelper.get(key)));
				response = HttpTookit.get(url, params, headers);
				response = JSONHelper.toJsonString(response);
				json = JSONObject.parseObject(response);
			}
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		return json;
	}

    public static JSONObject getFileCheck(String fileName, String parentId) throws BusinessException {
        String url = BASE_HOST + "/api/xbase/v1/model/name/check";
        Map<String, String> headers = new HashMap<>();
        headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
        JSONObject params = new JSONObject();
        params.put("app_id", APP_ID);
        params.put("is_folder", false);
        params.put("model_name", fileName);
        params.put("parent_id", StringUtils.isNotBlank(parentId) ? parentId : APP_ID);
        JSONObject json = null;
        try {
            String response = HttpTookit.postByJson(url, params.toJSONString(), headers, HttpTookit.connTimeout, HttpTookit.readTimeout);
            json = JSONObject.parseObject(response);
            if(json.getInteger("code").equals(new Integer("10010001"))){
                getTokenData();
                headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
                response = HttpTookit.postByJson(url, params.toJSONString(), headers, HttpTookit.connTimeout, HttpTookit.readTimeout);
                json = JSONObject.parseObject(response);
            }
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        return json;
    }

	public static String download(String modelId) throws BusinessException {
		String url = BASE_HOST + "/api/xbase/v1/model/download";
		Map<String, String> headers = new HashMap<>();
		headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
		Map<String, String> params = new HashMap<>();
		params.put("model_id", modelId);
		String response = null;
		try {
			response = HttpTookit.get(url, params, headers);
			JSONObject json = JSONHelper.parseObject(response);
			if(json != null && json.getInteger("code").equals(new Integer("10010001"))){
				getTokenData();
				headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
				response = HttpTookit.get(url, params, headers);
			}
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		return response;
	}

	public static JSONObject getFileList(String parentId) throws BusinessException {
		String url = BASE_HOST + "/api/xbase/v1/model/models";
		Map<String, String> headers = new HashMap<>();
		headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
		Map<String, Object> params = new HashMap<>();
		params.put("parent_id", parentId);
		params.put("page_num", 1);
		params.put("page_size", 1000);
		params.put("order_by", 1);
		params.put("sort_by", 1);
		params.put("app_id", APP_ID);
		JSONObject json = null;
		try {
			String response = HttpTookit.get(url, params, headers);
			json = JSONObject.parseObject(response);
			if(json.getInteger("code").equals(new Integer("10010001"))){
				getTokenData();
				headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
				response = HttpTookit.get(url, params, headers);
				json = JSONObject.parseObject(response);
			}
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		return JSONHelper.castDataJson(json, JSONObject.class);
	}

	// -------------------------------------------私有方法end---------------------------------------------------------

	public static void main(String[] args) {
		List<String> modelIds = new ArrayList<>();
//		modelIds.add("dea5f6f32aab4b46b0d3f6ceb4f546ea");
		modelIds.add("a657068f2b924913ac11aefd13d94c6a");
//		modelIds.add("0de16ae658e449f8b658343f66a62686");
//		modelIds.add("5984006da3014547abbb91f075d4332b");
//		modelIds.add("143868ba2cd341c994485d9757d86099");
//		modelIds.add("300fe8b344a345e98b35e5702e7431eb");
//		JSONObject json = delFileBatch(modelIds.toArray(new String[0]));
//		System.out.println(json);
		JSONObject json1 = getViewerToken("a901e0decd144e74bb8945c490442d7c");
		System.out.println(json1);
	}
}
